<?php include("/web/messages/include/session.php");
include_once("/web/messages/include/ldap_queries.php");
include_once($_SERVER['DOCUMENT_ROOT']."/includes/_williams-lib.php");//include constants/server variables


$js   = addScript(PROTOPACKED).
        addScript(WILLIAMS_SCRIPTS."validation/validation.js");
		



#############################################################
# takes: a username and password
#
# returns: the user context (STUDENT, FACULTY, STAFF, AFFILIATE, or
# UNKNOWN) if the username password combo is valid (i.e. can be used
# to bind to LDAP) and false (0) otherwise
#
# NOTE: checks against nds1 and nds2
#
function authenticateAgainstLDAP($username='x',$password='y')
{
  $debug = 0;
  if (! $username) { $username = 'x'; }
  if (! $password) { $password = 'y'; }

  $ldap_servers = array('ldaps://nds1.williams.edu','ldaps://nds2.williams.edu');

  $connected = 0;
  $server_index = 0;
  $return_val = 0;

  if ($debug) { echo "auth process starting\n"; }

  while ((! $connected) && ($server_index < count($ldap_servers)))
  {
    $cur_server = $ldap_servers[$server_index];
    if ($debug) { echo "trying $cur_server, connection status = $connected, server_index is $server_index\n"; }
    $link = ldap_connect($cur_server);
    if ($link)
    {
      if ($debug) { echo "connection succeeded\n"; }
      $connected = 1;
      $anon_bind = ldap_bind($link);
      if ($anon_bind)
      {
        if ($debug) { echo "anon bind succeeded\n"; }
        $search = ldap_search($link,'o=williams',"cn=$username");
        if ($search)
        {
          if ($debug) { echo "search exists\n"; }
          $results = ldap_get_entries($link, $search);
          if ($results)
          {
            if ($debug) { echo "got some kind of results\n"; }
            if ($results['count'] == 0)
            {
              if ($debug) { echo "no (count == 0) data in search results\n"; }
              # no results - user does not exists
              $return_val = 0;
            }
            else if ($results['count'] > 1)
            {
              if ($debug) { echo "too many ({$results['count']}) search results\n"; }
              # multiple results - username appears more than once - invalid
              $return_val = 0;
            }
            else # exactly 1 result
            {
              if ($debug) { echo "exactly 1 search result\n"; }
              # get the dn from the anon search
              $user_dn = $results[0]["dn"];
              if ($debug) { echo "user dn is $user_dn\n"; }
              # now try a non-anon bind to authenticate the user
              $auth_bind = ldap_bind($link,$user_dn,$password);
              if ($auth_bind)
              {
                if ($debug) { echo "auth bind succeeded\n"; }
                # parse the dn to get the context
                if (preg_match('/ou=(\w+)/',$user_dn,$matches))
                {
                  if ($debug) { echo "regex match succeed to some degree at least\n"; }
                  if ($matches[1])
                  {
                    if ($debug) { echo "SUCCESS, context is $matches[1]\n"; }
                    $return_val = $matches[1];
                  } else # bind OK, but no match in the dn so context unknown
                  {
                    if ($debug) { echo "ou but no actual context\n"; }
                    $return_val = 'UNKNOWN';
                  }
                } else # no ou in the dn so context unknown
                {
                  if ($debug) { echo "no ou found\n"; }
                  $return_val = 'UNKNOWN';
                }
              } else # auth bind failed
              {
                if ($debug) { echo "authenticated bind failed\n"; }
                $return_val = 0;
              }
            }
          } else # anon search results failed
          {
            if ($debug) { echo "could not get anon search results\n"; }
            ldap_close($link);
            $connected = 0;
            $server_index++;
          }

          # regardless of the content, don't forget to free the result
          ldap_free_result($results);  

        } else # could not search
        {
          if ($debug) { echo "could not search\n"; }
          ldap_close($link);
          $connected = 0;
          $server_index++;
        }
      } else # could not bind anonymously
      {
        if ($debug) { echo "could not anon bind to $cur_server\n"; }
        ldap_close($link);
        $connected = 0;
        $server_index++;
      }      
    } else # could not connect
    {
      if ($debug) { echo "could not connect to $cur_server\n"; }
      $server_index++;
    }
  }
  
  if ($link) 
  { 
    if ($debug) { echo "cleaning up link\n"; }
    ldap_close($link); 
  }

  if ($debug) { echo "returning $return_val\n"; }
  return $return_val;
}


       $host         = $_SERVER['HTTP_HOST'];
       $uri           = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	   $post_page    = 'post_message.php';


$page ="https://$host$uri/". ($_REQUEST['ref'] ? $_REQUEST['ref'] : $post_page);

//Login details posted...
if($_POST) {
  if (!$_SESSION['authenticated'])
  {  
    //printf($debugmessage,"Session Auth: ".$_SESSION['authenticated']);

    $_SESSION['authenticated'] = authenticateAgainstLDAP($_POST['username'],$_POST['password']);
    $_SESSION['userid']        = $_POST['username'];
   //if still not auth
   if (!$_SESSION['authenticated']) 
     $login_message = 'Your username - password combination was not valid.';
  }
  
  if ($_SESSION['authenticated']) {
        //It DID authenticate
	  $all_user_info = getInfoForPerson($_SESSION['userid']);
	  $_SESSION['username'] = $all_user_info['givenname'];
      header("Location: $page");
  }
   
  
}

else {

//echo "<!-- ".(isset($_SESSION['authenticated']) ? "Yes it's set" : "No it's not set") . " value= '".$_SESSION['authenticated']."' page=".$page."-->";
  if($_SESSION['authenticated']) {header("Location: $page");}

}






$login_message = ($_GET['login_message'] ? $_GET['login_message'] : $login_message);
$login_message = ($login_message=="Please login with your Williams username and password." ? "" : $login_message);
include_once($_SERVER['DOCUMENT_ROOT']."/includes/_williams-lib.php");//include constants/server variables
include_once("/web/messages/include/DM_head.php");
?>
<script>

  function onLoadHandler()
  {
    document.getElementById("username_ID").focus();
  }
</script>
<style>
.errormsg { background-color: #FFB9B9; font-weight:bold; color:black;  border:1px solid #CC3333; padding:4px;}
label     {font-family:"Trebuchet MS", Trebuchet, Verdana, Arial; color:#330066; font-size:12px; display:block; margin:0 0 4px 0;}
</style>

<table id="showMessages"  border="0" cellspacing="0" cellpadding="0" align="center" summary="table">
  <tr>
    <td valign="top" width="540" style="padding:10px;" > 
	<h1>Daily Messages Login</h1>
	<p style="margin-left:0">Log-in with your Williams username and password to post messages. </p>
	<? echo ($login_message ? "<p class='errormsg'>".$login_message."</p>" : ""); ?>
	<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" id='loginform'>
	  <input type="hidden" name='ref' value="<?=$_REQUEST['ref'];?>" />
	  <label for="username_ID">Username:</label>
        <input style="width:160px;" class="required" type="text" value="<?=$_REQUEST['username'];?>" name="username" id="username_ID" size="16" maxlength="48" />
        <br /><br />
        <label for="password">Password:</label>
        <input style="width:160px;" class="required" value="" id="password" type="password" name="password" size="16" maxlength="48" />
        <br /><br />
        <input type="submit" name="login" value="login" />
      </form>
	  
    <p>&nbsp;</p>
	
	<p>The <b>deadline</b> for submitting a message is <b>3 p.m. Monday through Friday</b>. <i>Messages for Monday's Daily Messages must be submitted by <b>3 p.m. on Friday</b>.</i></p>
<p><b>Daily Messages are e-mailed on weekdays only.</b> <i>Daily Messages are not e-mailed on Saturday or Sunday.</i> </p>
<p>Messages may be <strong>edited</strong> for <strong>clarity</strong> or <strong>acceptability</strong>. </p>
<p>The   <b>Daily Messages</b> system enables the efficient distribution of notices of campus-wide interest - news, events, and information for and about the Williams community. 
  <i>Messages for or from outside groups, lost and found notices, or attempts to sell goods and services are forbidden.</i>
    <br />
    <br />
  For more information, contact Daily Messages editors at <a href="mailto:dailymessage@williams.edu?subject=Daily Messages">dailymessage@williams.edu</a> or call (413) 597-4277.
  <br />
  <br />
  For technical assistance, call the Help Desk at 597-4090 (faculty &amp; staff) or 597-3088 (students).</p>

	</td>
<td bgcolor="#eee5c6" width="200" id="sidecolumn" >


<h4 class="sidecolumn_dotted" style="padding:15px 0 15px 0; "><a href="<?="https://$host$root_loc/";?>">Daily Messages Home</a></h4>


</td>
</tr>
</table>
<script>

   function formCallback(result, form) {window.status = "validation callback for form '" + form.id + "': result = " + result;}
   var valid = new Validation('loginform', {immediate : true, onFormValidate : formCallback});

</script>

<?php
include_once("/web/messages/include/DM_foot.php"); 
?>
