<?php 

session_set_cookie_params(60*60*2); # two hour sessions
session_start();

if (! $_SESSION['authenticated'])
{
  session_write_close();
  $host  = $_SERVER['HTTP_HOST'];
  $uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
  $login_page = 'index.php';
  $message = 'Page access denied - login is required to use that tool.';
  header("Location: http://$host$uri/$login_page?login_message=".urlencode($message));
  exit;
}

#####################################################################
function verifyResult($res,$msg_on_failure,$sql)
{
  if (! $res)
  {
    if ($sql)
    {
      echo "SQL:<br>\n$sql<br>\n";
    }
    echo $msg_on_failure."<br>\n";
    echo mysql_error();
    exit;
  }
}

#####################################################################
function myDebug($level,$msg)
{
  global $DEBUG_LEVEL;
  if ($DEBUG_LEVEL >= $level)
  {
    echo "$msg<br>\n";
  }
}

#####################################################################

include_once("../include/DM_head.php");
include_once("../include/db.php");

$audience = preg_replace('/^\'|\'$/','',quote_smart($_REQUEST['audience']));
$audience_title = '';
$audience_key_field_condition = '';

$class_student_button = "preview_button";
$class_faculty_button = "preview_button";
$class_staff_button = "preview_button";
$class_other_button = "preview_button";
$class_combined_button = "preview_button";
$load_focus_button = "preview_combined_button_ID";

switch ($audience) {
  case "students":
    $audience_title = 'student';
    $audience_key_field_condition = 'audience_students';
    $class_student_button = "preview_button_clicked";
    $load_focus_button = "preview_student_button_ID";
    break;
  case "faculty":
    $audience_title = 'faculty';
    $audience_key_field_condition = 'audience_faculty';
    $class_faculty_button = "preview_button_clicked";
    $load_focus_button = "preview_faculty_button_ID";
    break;
  case "staff":
    $audience_title = 'staff';
    $audience_key_field_condition = 'audience_staff';
    $class_staff_button = "preview_button_clicked";
    $load_focus_button = "preview_staff_button_ID";
    break;
  case "other":
    $audience_title = 'sponsored affiliates';
    $audience_key_field_condition = 'audience_other';
    $class_other_button = "preview_button_clicked";
    $load_focus_button = "preview_other_button_ID";
    break;
  case "combined":
    $audience = 'summary';
    $audience_title = 'combined';
    $audience_key_field_condition = 'all_audience';
    $class_combined_button = "preview_button_clicked";
    $load_focus_button = "preview_combined_button_ID";
    break;
  default:
    $audience = 'summary';
    $audience_title = 'combined';
    $audience_key_field_condition = 'all_audience';
    $class_combined_button = "preview_button_clicked";
    $load_focus_button = "preview_combined_button_ID";
    break;
}

# collect the ids for the full messages and the foreshadow messages

# pre-loaded with -1 to make the SQL work out and not to match any messages if there's none in the email
$full_message_ids_list = array(-1);
$foreshadow_message_ids_list = array(-1);

$sql_full_messages_for_email =
"SELECT 
  m.message_id
 FROM 
  message m
 WHERE 
  m.category_id != 0
  AND m.refused_flag = 0
  AND m.published_flag = 0
  AND m.to_publish_flag = 1
  AND (m.to_foreshadow_flag = 0 
       OR
       IF(m.active_datetime IS NULL OR m.active_datetime = '0000-00-00 00:00:00',
          1=0,
          IF(DATE_FORMAT(m.active_datetime,'%W')='Monday',
             m.active_datetime <= DATE_ADD(NOW(), INTERVAL 71 HOUR),
             m.active_datetime <= DATE_ADD(NOW(), INTERVAL 23 HOUR)
             )
          )
       )";

$res_full_messages_for_email = mysql_query($sql_full_messages_for_email);
verifyResult($res_full_messages_for_email,"failed to get full messages for email",$sql_full_messages_for_email);

while ($row_full_message = mysql_fetch_assoc($res_full_messages_for_email))
{
  array_push($full_message_ids_list,$row_full_message['message_id']);
}

$sql_foreshadow_messages_for_email =
"SELECT m.message_id
 FROM message m
 WHERE
  m.refused_flag = 0
  AND m.published_flag = 0
  AND m.foreshadowed_flag = 0
  AND
  (m.to_foreshadow_flag = 1
   AND IF(m.summary_datetime IS NULL OR m.summary_datetime = '0000-00-00 00:00:00',
         1=1,
         IF(DATE_FORMAT(m.summary_datetime,'%W')='Monday',
            m.summary_datetime <= DATE_ADD(NOW(), INTERVAL 71 HOUR),
            m.summary_datetime <= DATE_ADD(NOW(), INTERVAL 23 HOUR)
            )
         )
   )";

$res_foreshadow_messages_for_email = mysql_query($sql_foreshadow_messages_for_email);
verifyResult($res_foreshadow_messages_for_email,"failed to get foreshadow messages for email",$sql_foreshadow_messages_for_email);

while ($row_foreshadow_message = mysql_fetch_assoc($res_foreshadow_messages_for_email))
{
  array_push($foreshadow_message_ids_list,$row_foreshadow_message['message_id']);
}


# 2. Build the message texts
# 2.a. get all the messages, in the right order, with category info
# 2.b. add each message to the appropriate section(s) and audience(s)
# 2.c. construct full texts
# 2.c.i.  string together sections
# 2.c.ii. add headers and footers

$email_groups = array(
  'students' => 'audience_students',
  'faculty'  => 'audience_faculty',
  'staff'    => 'audience_staff',
  'other'    => 'audience_other',
  'summary'  => 'all_audience');

$last_category = array();
$headlines = array();
$details = array();
$foreshadowing = array();
$full_message_text = array();
foreach ($email_groups as $group_name => $assoc_field)
{
  $last_category[$group_name]     = '';
  $headlines[$group_name]         = '';
  $details[$group_name]           = '';
  $foreshadowing[$group_name]     = '';
  $full_message_text[$group_name] = '';
}

$DAY = array('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
$MONTH = array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
$the_time = localtime(time(),1);
$DATE_TAG = $DAY[$the_time['tm_wday']].', '.$MONTH[$the_time['tm_mon']].' '.$the_time['tm_mday'].', '.($the_time['tm_year']+1900);

$horiz_line_size = 70;
$horiz_line = '';
$email_title = "D A I L Y   M E S S A G E S";
while (strlen($horiz_line) < $horiz_line_size)
{
  $horiz_line .= '_';
  if (strlen($email_title) < $horiz_line_size)
  {
    $email_title .= ' ';
  }
}
# now replace some of the blanks on the right with the date tag
$email_title = substr($email_title,0,(-1 * strlen($DATE_TAG))).$DATE_TAG;

// Get live footer from database
$footer_res = mysql_query('SELECT footer_text FROM email_footer_text limit 1;');
$footer_text = mysql_fetch_assoc($footer_res);
$message_footer = $footer_text['footer_text'];

$foreshadow_ids_list_csv = join(',',$foreshadow_message_ids_list);
$all_ids_list_csv = join(',',$full_message_ids_list) . ',' . $foreshadow_ids_list_csv;

$sql_message_details = "
SELECT
 c.category_name,
 m.message_id,
 m.headline,
 m.short_body,
 m.short_summary,
 m.audience_students,
 m.audience_faculty,
 m.audience_staff,
 m.audience_other,
 1 AS all_audience,
 m.to_publish_flag,
 m.published_flag,
 m.to_foreshadow_flag,
 m.foreshadowed_flag,
 IF(m.message_id IN ($foreshadow_ids_list_csv),1,0) AS foreshadow_flag
FROM
 message m,
 category c
WHERE 1=1
 AND m.message_id IN ($all_ids_list_csv)
 AND c.category_id=m.category_id
ORDER BY
 foreshadow_flag,
 c.category_ordering,
 m.ordering";
$res_message_details = mysql_query($sql_message_details);
verifyResult($res_message_details,"failed to get message details",$sql_message_details);

$message_ordination = array(
                            'students' => 0,
                            'faculty'  => 0,
                            'staff'    => 0,
                            'other'    => 0,
                            'summary'  => 0);

while ($row_message_details = mysql_fetch_assoc($res_message_details))
{
  # DEBUGGING OUTPUT
  if ($DEBUG_LEVEL > 3)
  {
    echo "<pre>";
    print_r($row_message_details);
    echo "</pre>";
  }

  myDebug(3,"handling category transitions for ".$row_message_details['message_id']);
  foreach ($email_groups as $group_name => $assoc_field)
  {
    myDebug(4,"for group $group_name, using $assoc_field");
    if ($row_message_details[$assoc_field] == 1)
    {
      myDebug(5,"this group OK");
      if ($row_message_details['category_name'] != $last_category[$group_name])
      {
        myDebug(4,"new category");
        if (! $row_message_details['foreshadow_flag'])
        {
          myDebug(4,"adding category to headlines");
          #$headlines[$group_name] .= "\n\n".strtoupper($row_message_details['category_name']);
          $headlines[$group_name] .= "\n\n     === ".$row_message_details['category_name']." ===";

          if ($last_category[$group_name] != '')
          {
            myDebug(4,"adding breakline and category to details");
            #$details[$group_name]   .= "\n$horiz_line\n\n".strtoupper($row_message_details['category_name']);
            #$details[$group_name]   .= "\n$horiz_line\n\n====== ".$row_message_details['category_name']." ======";
            $details[$group_name]   .= "\n\n    === ".$row_message_details['category_name']." ===";
          } else
          {
            myDebug(4,"adding initial category to details");
            #$details[$group_name]   .= strtoupper($row_message_details['category_name']);
            #$details[$group_name]   .= "\n$horiz_line\n\n".strtoupper($row_message_details['category_name']);
            #$details[$group_name]   .= "\n$horiz_line\n\n====== ".$row_message_details['category_name']." ======";
            $details[$group_name]   .= "\n\n    === ".$row_message_details['category_name']." ===";
          }
          $last_category[$group_name] = $row_message_details['category_name'];
        } else
        {
          myDebug(6,"but message is foreshadowing only, so doing nothing");
        }
      }
    
      if (! $row_message_details['foreshadow_flag'])
      {
        myDebug(2,"adding message to headlines and details");
        $message_ordination[$group_name]++;
        $ordination_text = $message_ordination[$group_name];
        if ($ordination_text < 10)
          {
            $ordination_text = " $ordination_text";
          }
        $ordination_text .= '.';
 
        #$headlines[$group_name] .= "\n   * ".$row_message_details['headline'];
        $headlines[$group_name] .= "\n $ordination_text ".$row_message_details['headline'];
        #$m_short_body = "\n".$row_message_details['short_body'];
        $m_short_body = $row_message_details['short_body'];

        #$details[$group_name] .= "\n$m_short_body";
        $details[$group_name] .= "\n\n$ordination_text $m_short_body";
      } else 
      {
        myDebug(4,"adding message to foreshadowing");
        $foreshadowing[$group_name] .= "\n   * ".$row_message_details['short_summary'];
      }
    } # end if audience valid

    # DEBUGGING OUTPUT
    if ($DEBUG_LEVEL > 5)
    {
      echo "<pre>\n";
      echo "\nlast_category $group_name\n";
      echo $last_category[$group_name];
      echo "\nheadlines $group_name\n";
      echo $headlines[$group_name];
      echo "\ndetails $group_name\n";
      echo $details[$group_name]   ;        
      echo "\nforeshadowing $group_name\n";     
      echo $foreshadowing[$group_name];     
      echo "\nfull_message_text $group_name\n"; 
      echo $full_message_text[$group_name]; 
      echo "</pre>\n";
    }

  } # end foreach group

} # end while rows


foreach ($email_groups as $group_name => $assoc_field)
{
  if ((strlen($details[$group_name]) > 0) || (strlen($foreshadowing[$group_name])> 0))
  {

    $full_message_text[$group_name] = "$horiz_line\n\n$email_title\n$horiz_line";

    if (strlen($details[$group_name]) > 0)
    {
      #$full_message_text[$group_name] .= "$headlines[$group_name]\n";
      $full_message_text[$group_name] .= "$headlines[$group_name]\n$horiz_line";
    }

    if (strlen($foreshadowing[$group_name]) > 0)
    {
      $full_message_text[$group_name] .= "\nUPCOMING$foreshadowing[$group_name]\n";
    }

    $full_message_text[$group_name] .= "$details[$group_name]\n$horiz_line";
    $full_message_text[$group_name] .= "\n$message_footer";
  }

  # DEBUGGING OUTPUT
  if ($DEBUG_LEVEL > 1)
  {
    echo "<hr>\n<pre>".$group_name."\n";
    echo $full_message_text[$group_name];
    echo "</pre>\n<hr>\n";
  }
}
?>

<script language="JavaScript">
//<![CDATA[

  function onLoadHandler()
  {
    document.getElementById("<?php echo $load_focus_button; ?>").focus();
  }
//]]>
</script>

<?php 
include("/web/messages/admin/include/admin_nav_bar.php"); 
include("../include/hr.php"); 
?>

<table class="admin_content_table" cellspacing="0" summary="table">
 <tr>
  <td class="admin_lefthand_col">
<b>PREVIEW DAILY MESSAGES</b>
<br />
<br />
Click a button to see a preview of the email to be sent to that audience.<br />
<br />
<form method="preview.php" method="POST">
<input type="hidden" name="audience" value="combined">
<input type="submit" class="<?php echo $class_combined_button; ?>" name="preview_combined_button" id="preview_combined_button_ID" value="Combined">
</form>
<br />
<form method="preview.php" method="POST">
<input type="hidden" name="audience" value="students">
<input type="submit" class="<?php echo $class_student_button; ?>" name="preview_student_button" id="preview_student_button_ID" value="Student">
</form>
<br />
<form method="preview.php" method="POST">
<input type="hidden" name="audience" value="faculty">
<input type="submit" class="<?php echo $class_faculty_button; ?>" name="preview_faculty_button" id="preview_faculty_button_ID" value="Faculty">
</form>
<br />
<form method="preview.php" method="POST">
<input type="hidden" name="audience" value="staff">
<input type="submit" class="<?php echo $class_staff_button; ?>" name="preview_staff_button" id="preview_staff_button_ID" value="Staff">
</form>
<br />
  </td>
  <td class="admin_righthand_col">
<center class="big_text">This is a preview of the <?php echo $audience_title; ?> email.</center>

<pre style="font-family: monaco, monospace; font-size: 8pt;">
<?php
if ($full_message_text[$audience])
{
  echo $full_message_text[$audience];
} else
{
  echo 'No email to be sent to that audience today';
}
?>
</pre>

  </td>
 </tr>
</table>

<?php
include("../include/DM_foot.inc");
?>
