<?php 
session_set_cookie_params(60*60*2); # two hour sessions
session_start();
include_once($_SERVER['DOCUMENT_ROOT']."/includes/_williams-lib.php");//include constants/server variables

//include("/web/messages/include/DM_head.inc");  //Skye 5/23/07 - Eliminate any 'design' or HTML

$DEBUG = 0;

//Skye 05-23-07
//Initialize Default Results to pull today's messages for all audiences.
$todays_messages = date("Y/m/d"); //format yyyy-mm-dd
$day_of_week = date("l"); 

//Skye 05-23-07
//On weekends, show previous Friday's messages.
if      ($day_of_week=="Saturday") $todays_messages = date("Y/m/d",strtotime("-1 day"));
else if ($day_of_week=="Sunday"  ) $todays_messages = date("Y/m/d",strtotime("-2 day"));

//Validate to make sure date isn't a nonsense string
if($_GET['begin_date'])
{
   if (($timestamp =  strtotime($_GET['begin_date'])) === false) $_GET['begin_date']=NULL;

}

if($_GET['end_date'])
{
   if (($timestamp =  strtotime($_GET['end_date'])) === false) $_GET['end_date']=NULL;

}


//Skye 05-23-07
//Altered Chris' code slightly - instead of dates being the value of $_GET variables, if $_GET isn't set then set the date to $today
$begin_date = quote_smart( (isset($_GET['begin_date'])  ?  $_GET['begin_date'] : $todays_messages)  );
$end_date = quote_smart(   (isset($_GET['end_date'])    ?  $_GET['end_date']   : $todays_messages)  );



//Skye 05-23-07
//Altered Chris' code slightly - set all audiences to TRUE unless set by the $_GET variable from the form.
# NOTE: this data not being passed directly into a query - tests for existence only
$default_dates = (isset($_GET['begin_date']) || isset($_GET['end_date']) ? false : true);

$audience_student = (!$default_dates ? $_GET['search_audience_student'] : true);
$audience_faculty = (!$default_dates ? $_GET['search_audience_faculty'] : true);
$audience_staff   = (!$default_dates ? $_GET['search_audience_staff']   : true);
$audience_other   = $_GET['audience_other'];

# NOTE: search terms are tricky! Not quote_smart-ing here because we
# do various processing depending on quotes. Later quote_smart-ing
# each term.
$search_terms = preg_replace('/^\s+|\s+$/','',$_GET['search_terms']);

// CPH: 3/13/18 Strip javascript special characters from search terms
$search_terms = preg_replace('/[\/\#+=<>()|\$]/','',$search_terms);

$date_default_value = quote_smart('----/--/--');

if ($DEBUG > 1)
{
  echo "<pre>\n";
  echo "todays message = $todays_messages\n";
  echo "day of week = $day_of_week\n";
  echo "begin_date = $begin_date\n";
  echo "end_date = $end_date\n";
  echo "audience_student = $audience_student\n";
  echo "audience_faculty = $audience_faculty\n";
  echo "audience_staff = $audience_staff\n";
  echo "audience_other = $audience_other\n";
  echo "search_terms = $search_terms\n";
  echo "</pre>\n";
}


$ar_search_terms = array();
$ar_search_terms['plain'] = array();
$ar_search_terms['quoted'] = array();

if ($search_terms)
{
  # NOTE: handling of quoted terms is tricky. The convolutions here
  # are an attempt to make any quoted terms containing quotes behave
  # as intuitively as possible for the end user. The cases that make
  # this do strange things will likely rarely or never actually be
  # used by a real user.

  # first pull out double quoted terms, no interior quotes
  preg_match_all('/("[^"\']*?")/',$search_terms,$matches);
  $quotes_matches = $matches[1];
  
  if ($DEBUG > 2)
  {
    echo "<pre>\n";
    echo "matches = ";
    print_r($matches);
    echo "quotes_matches = ";
    print_r($quotes_matches);
    echo "</pre>\n";
  }

  if ($quotes_matches)
  {
    foreach ($quotes_matches as $quoted_term)
    {
      $search_terms = preg_replace("/$quoted_term/",'',$search_terms);
      $quoted_term = preg_replace('/^"|"$/','',$quoted_term);
      array_push($ar_search_terms['quoted'],$quoted_term);
    }
  }

  # repeat double quoted ones for terms containing single quotes
  preg_match_all('/("[^"]*?")/',$search_terms,$matches);
  $quotes_matches = $matches[1];
  
  if ($DEBUG > 2)
  {
    echo "<pre>\n";
    echo "matches = ";
    print_r($matches);
    echo "quotes_matches = ";
    print_r($quotes_matches);
    echo "</pre>\n";
  }

  if ($quotes_matches)
  {
    foreach ($quotes_matches as $quoted_term)
    {
      $search_terms = preg_replace("/$quoted_term/",'',$search_terms);
      $quoted_term = preg_replace('/^"|"$/','',$quoted_term);
      array_push($ar_search_terms['quoted'],$quoted_term);
    }
  }

  # then check for single quoted terms containing double quotes
  preg_match_all("/(\'[^\']*?\')/",$search_terms,$matches);
  $quotes_matches = $matches[1];

  if ($DEBUG > 2)
  {
    echo "<pre>\n";
    echo "matches = ";
    print_r($matches);
    echo "quotes_matches = ";
    print_r($quotes_matches);
    echo "</pre>\n";
  }

  if ($quotes_matches)
  {
    foreach ($quotes_matches as $quoted_term)
    {
      $search_terms = preg_replace("/$quoted_term/",'',$search_terms);
      $quoted_term = preg_replace("/^'|'$/",'',$quoted_term);
      array_push($ar_search_terms['quoted'],$quoted_term);
    }
  }

  # then repeat check for single quoted terms with no double quotes
  preg_match_all("/(\'[^\'\"]*?\')/",$search_terms,$matches);
  $quotes_matches = $matches[1];

  if ($DEBUG > 2)
  {
    echo "<pre>\n";
    echo "matches = ";
    print_r($matches);
    echo "quotes_matches = ";
    print_r($quotes_matches);
    echo "</pre>\n";
  }

  if ($quotes_matches)
  {
    foreach ($quotes_matches as $quoted_term)
    {
      $search_terms = preg_replace("/$quoted_term/",'',$search_terms);
      $quoted_term = preg_replace("/^'|'$/",'',$quoted_term);
      array_push($ar_search_terms['quoted'],$quoted_term);
    }
  }

  # now deal with any plain terms that are left
  $search_terms = preg_replace('/\s+/',' ',$search_terms);
  $search_terms = preg_replace('/^\s+|\s$/','',$search_terms);
  if ($search_terms)
  {
    $search_terms = strtoupper($search_terms);
    $ar_search_terms['plain'] = explode(' ',$search_terms);
  }
}


$scoring_col = '0';
$matching_conditions = '1=0';

foreach ($ar_search_terms['quoted'] as $qst)
{
  $qst = quote_smart($qst);

  # stripping begin and end quote so we can do fuzzy matching (LIKE conditions)
  $qst =  preg_replace('/^\'+|\'+$/','',$qst);

  $scoring_col .= "+ IF(INSTR(headline,'$qst'),2,0) + IF(INSTR(short_body,'$qst'),1.5,0) + IF(INSTR(long_body,'$qst'),1,0)";
  $matching_conditions .= " OR headline LIKE '%$qst%' OR short_body LIKE '%$qst%' OR long_body LIKE '%$qst%'";
}

foreach ($ar_search_terms['plain'] as $pst)
{
  $pst = quote_smart($pst);

  # stripping begin and end quote so we can do fuzzy matching (LIKE conditions)
  $pst =  preg_replace('/^\'+|\'+$/','',$pst);

  $scoring_col .= "+ IF(INSTR(UPPER(headline),'$pst'),1.5,0) + IF(INSTR(UPPER(short_body),'$pst'),1.25,0) + IF(INSTR(UPPER(long_body),'$pst'),.75,0)";
  $matching_conditions .= " OR UPPER(headline) LIKE '%$pst%' OR UPPER(short_body) LIKE '%$pst%' OR UPPER(long_body) LIKE '%$pst%'";
}
if ($matching_conditions == '1=0')
{
  $matching_conditions = '1=1';
}


$audience_conditions = '(1=0';
if ($audience_student)
{
  $audience_conditions .= ' OR audience_students=1';
}
if ($audience_faculty)
{
  $audience_conditions .= ' OR audience_faculty=1';
}
if ($audience_staff)
{
  $audience_conditions .= ' OR audience_staff=1';
}
if ($audience_other)
{
  $audience_conditions .= ' OR audience_other=1';
}
$audience_conditions .= ')';


$date_range_conditions = '1=1';
if (($begin_date) && ($begin_date != $date_default_value))
{
  $date_range_conditions .= " AND publish_datetime >= STR_TO_DATE($begin_date,'%Y/%m/%d')";
}
if (($end_date) && ($end_date  != $date_default_value))
{
  $date_range_conditions .= " AND publish_datetime <= DATE_ADD(STR_TO_DATE($end_date,'%Y/%m/%d'), INTERVAL 23 HOUR)";
}


//Skye 11/18/09
//Just discovered thata line of sql after 'published_flag=1' was preventing searches from more than 1 year ago.
//I removed this line so people can search the full DM db.
//The sql was:	AND publish_datetime >= NOW() - INTERVAL 365 DAY

$sql_get_search_results = "
SELECT
message_id,
headline,
short_body,
long_body,
audience_students,
audience_faculty,
audience_staff,
audience_other,
DATE_FORMAT(publish_datetime,'%a, %b %d, %Y') as publication_date,
$scoring_col AS match_score
FROM 
message
WHERE
published_flag=1

AND $audience_conditions
AND $date_range_conditions
AND ($matching_conditions)
ORDER BY
match_score DESC,
publish_datetime DESC,
message_id";

if ($DEBUG > 0)
{
  echo "<pre>\n";
  echo "begin_date = $begin_date\n";
  echo "end_date = $end_date\n";
  echo "audience_student = $audience_student\n";
  echo "audience_faculty = $audience_faculty\n";
  echo "audience_staff = $audience_staff\n";
  echo "audience_other = $audience_other\n";
  print_r($ar_search_terms);
  echo wordwrap("sql_get_search_results = \n$sql_get_search_results\n");
  echo "</pre>\n";
}

$res_get_search_results = mysql_query($sql_get_search_results);
$num_results =  mysql_num_rows($res_get_search_results);
$num_results_message = $num_results==1?'1 message found':"$num_results messages found";

?>

