<?php

#############################################################
# takes: a username and password
#
# returns: the user context (STUDENT, FACULTY, STAFF, AFFILIATE, or
# UNKNOWN) if the username password combo is valid (i.e. can be used
# to bind to LDAP) and false (0) otherwise
#
# NOTE: checks against adldap
#
function authenticateAgainstLDAP($username='x', $password='y')
{
    $debug = 0;
    if (!$username) {
        $username = 'x';
    }
    if (!$password) {
        $password = 'y';
    }

    $ldap_server = 'adldap.williams.edu';

    $return_val = 0;

    if ($debug) {
        echo "auth process starting\n";
    }

    if ($debug) {
        echo "trying $ldap_server";
    }
    $link = ldap_connect($ldap_server);


    if ($link) {
        if ($debug) {
            echo "connection succeeded\n";
        }
        $search_bind = ldap_bind($link, 'ldapunix-dm', 'NgtiElQd44yMtgOJ0MDj');
        //  $search_bind = ldap_bind($link, 'ldapapps2','fn1fqEK1gsT2hnLMyvIm');
        if ($search_bind) {
            if ($debug) {
                echo "search bind succeeded\n";
            }
            $search = ldap_search($link, 'OU=williams,DC=ad,DC=williams,DC=edu', "cn=$username");
            if ($search) {
                if ($debug) {
                    echo "search exists\n";
                }
                $results = ldap_get_entries($link, $search);
                if ($results) {
                    if ($debug) {
                        echo "got some kind of results\n";
                    }
                    if ($results['count'] == 0) {
                        if ($debug) {
                            echo "no (count == 0) data in search results\n";
                        }
                        # no results - user does not exists
                        $return_val = 0;
                    } else if ($results['count'] > 1) {
                        if ($debug) {
                            echo "too many ({$results['count']}) search results\n";
                        }
                        # multiple results - username appears more than once - invalid
                        $return_val = 0;
                    } else # exactly 1 result
                    {
                        if ($debug) {
                            echo "exactly 1 search result\n";
                        }
                        # get the dn from the anon search
                        $user_dn = $results[0]["dn"];
                        if ($debug) {
                            echo "user dn is $user_dn\n";
                        }
                        # now try a non-anon bind to authenticate the user
                        $auth_bind = ldap_bind($link, $user_dn, $password);
                        if ($auth_bind) {
                            if ($debug) {
                                echo "auth bind succeeded\n";
                            }
                            # parse the dn to get the context
                            if (preg_match('/OU=(\w+)/', $user_dn, $matches)) {
                                if ($debug) {
                                    echo "regex match succeed to some degree at least\n";
                                }
                                if ($matches[1]) {
                                    if ($debug) {
                                        echo "SUCCESS, context is $matches[1]\n";
                                    }
                                    $return_val = $matches[1];
                                } else # bind OK, but no match in the dn so context unknown
                                {
                                    if ($debug) {
                                        echo "ou but no actual context\n";
                                    }
                                    $return_val = 'UNKNOWN';
                                }
                            } else # no ou in the dn so context unknown
                            {
                                if ($debug) {
                                    echo "no ou found\n";
                                }
                                $return_val = 'UNKNOWN';
                            }
                        } else # auth bind failed
                        {
                            if ($debug) {
                                echo "authenticated bind failed\n";
                            }
                            $return_val = 0;
                        }
                    }

                    # regardless of the content, don't forget to free the result
                    # $results is an array here not a resource identifier
                    ldap_free_result($search);

                } else # search for results failed
                {
                    if ($debug) {
                        echo "could not get search results\n";
                    }
                    // ldap_close($link);
                }

            } else # could not search
            {
                if ($debug) {
                    echo "could not search\n";
                }
                // ldap_close($link);
            }

        } else # could not bind for search
        {
            if ($debug) {
                echo "could not bind for search to $ldap_server\n";
            }
        }

        ldap_close($link);
    }
    else # could not connect
    {
        if ($debug) { echo "could not connect to $ldap_server\n"; }
    }

    if ($debug) { echo "returning $return_val\n"; }
    return $return_val;
}



//Added by Skye 2-19-08. Make Every page authenticate to LDAP.
$host  = $_SERVER['HTTP_HOST'];
$uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
session_set_cookie_params(60*60*2); # two hour sessions
ini_set("session.gc_maxlifetime", 60*60*2);


session_start();

$debugmessage = "<p style='width:700px; margin:0px auto; font-family: Courier New, Courier, Verdana; font-size:1.1em; background-color:white; padding:5px; border:1px solid blue; margin-bottom:20px;'>%s</p>";

//printf($debugmessage,"Session Start");

if (!$_SESSION['authenticated']) {
 //printf($debugmessage,"Not Auth");
 unset($_SESSION['generated']);
}

else {

   if (!isset($_SESSION['generated']))
    {
       $_SESSION['generated'] = time();
	   //printf($debugmessage,"Setting a new generated session time.");
    }
   else 
    {   
         //printf($debugmessage,"Generated time is set");
      // if the session is not allowed to live more, regenerate it
         if (time() - $_SESSION['generated'] > ini_get('session.gc_maxlifetime')){ 
	         //printf($debugmessage,"Regen session old: ".date('r',$_SESSION['generated']));
	          $_SESSION['generated'] = time();
		      //printf($debugmessage,"Regen session new: ".date('r',$_SESSION['generated']). " test:" .date('r'));
		    }
    }
	
	
	
}
?>