<?php

#############################################################
# takes: a username and password
#
# returns: the user context (STUDENT, FACULTY, STAFF, AFFILIATE, or
# UNKNOWN) if the username password combo is valid (i.e. can be used
# to bind to LDAP) and false (0) otherwise
#
# NOTE: checks against nds1 and nds2
#
function authenticateAgainstLDAP($username='x',$password='y')
{
  $debug = 1;
  if (! $username) { $username = 'x'; }
  if (! $password) { $password = 'y'; }

  $ldap_servers = array('ldaps://nds1.williams.edu','ldaps://nds2.williams.edu');

  $connected = 0;
  $server_index = 0;
  $return_val = 0;

  if ($debug) { echo "auth process starting\n"; }

  while ((! $connected) && ($server_index < count($ldap_servers)))
  {
    $cur_server = $ldap_servers[$server_index];
    if ($debug) { echo "trying $cur_server, connection status = $connected, server_index is $server_index\n"; }
    $link = ldap_connect($cur_server);
    if ($link)
    {
      if ($debug) { echo "connection succeeded\n"; }
      $connected = 1;
      $anon_bind = ldap_bind($link);
      if ($anon_bind)
      {
        if ($debug) { echo "anon bind succeeded\n"; }
        $search = ldap_search($link,'o=williams',"cn=$username");
        if ($search)
        {
          if ($debug) { echo "search exists\n"; }
          $results = ldap_get_entries($link, $search);
          if ($results)
          {
            if ($debug) { echo "got some kind of results\n"; }
            if ($results['count'] == 0)
            {
              if ($debug) { echo "no (count == 0) data in search results\n"; }
              # no results - user does not exists
              $return_val = 0;
            }
            else if ($results['count'] > 1)
            {
              if ($debug) { echo "too many ({$results['count']}) search results\n"; }
              # multiple results - username appears more than once - invalid
              $return_val = 0;
            }
            else # exactly 1 result
            {
              if ($debug) { echo "exactly 1 search result\n"; }
              # get the dn from the anon search
              $user_dn = $results[0]["dn"];
              if ($debug) { echo "user dn is $user_dn\n"; }
              # now try a non-anon bind to authenticate the user
              $auth_bind = ldap_bind($link,$user_dn,$password);
              if ($auth_bind)
              {
                if ($debug) { echo "auth bind succeeded\n"; }
                # parse the dn to get the context
                if (preg_match('/ou=(\w+)/',$user_dn,$matches))
                {
                  if ($debug) { echo "regex match succeed to some degree at least\n"; }
                  if ($matches[1])
                  {
                    if ($debug) { echo "SUCCESS, context is $matches[1]\n"; }
                    $return_val = $matches[1];
                  } else # bind OK, but no match in the dn so context unknown
                  {
                    if ($debug) { echo "ou but no actual context\n"; }
                    $return_val = 'UNKNOWN';
                  }
                } else # no ou in the dn so context unknown
                {
                  if ($debug) { echo "no ou found\n"; }
                  $return_val = 'UNKNOWN';
                }
              } else # auth bind failed
              {
                if ($debug) { echo "authenticated bind failed\n"; }
                $return_val = 0;
              }
            }
          } else # anon search results failed
          {
            if ($debug) { echo "could not get anon search results\n"; }
            ldap_close($link);
            $connected = 0;
            $server_index++;
          }

          # regardless of the content, don't forget to free the result
          ldap_free_result($results);  

        } else # could not search
        {
          if ($debug) { echo "could not search\n"; }
          ldap_close($link);
          $connected = 0;
          $server_index++;
        }
      } else # could not bind anonymously
      {
        if ($debug) { echo "could not anon bind to $cur_server\n"; }
        ldap_close($link);
        $connected = 0;
        $server_index++;
      }      
    } else # could not connect
    {
      if ($debug) { echo "could not connect to $cur_server\n"; }
      $server_index++;
    }
  }
  
  if ($link) 
  { 
    if ($debug) { echo "cleaning up link\n"; }
    ldap_close($link); 
  }

  if ($debug) { echo "returning $return_val\n"; }
  return $return_val;
}



//Added by Skye 2-19-08. Make Every page authenticate to LDAP.
$host  = $_SERVER['HTTP_HOST'];
$uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
session_set_cookie_params(60*60*2); # two hour sessions
ini_set("session.gc_maxlifetime", 60*60*2);


session_start();

$debugmessage = "<p style='width:700px; margin:0px auto; font-family: Courier New, Courier, Verdana; font-size:1.1em; background-color:white; padding:5px; border:1px solid blue; margin-bottom:20px;'>%s</p>";

//printf($debugmessage,"Session Start");

if (!$_SESSION['authenticated']) {
 //printf($debugmessage,"Not Auth");
 unset($_SESSION['generated']);
}

else {

   if (!isset($_SESSION['generated']))
    {
       $_SESSION['generated'] = time();
	   //printf($debugmessage,"Setting a new generated session time.");
    }
   else 
    {   
         //printf($debugmessage,"Generated time is set");
      // if the session is not allowed to live more, regenerate it
         if (time() - $_SESSION['generated'] > ini_get('session.gc_maxlifetime')){ 
	         //printf($debugmessage,"Regen session old: ".date('r',$_SESSION['generated']));
	          $_SESSION['generated'] = time();
		      //printf($debugmessage,"Regen session new: ".date('r',$_SESSION['generated']). " test:" .date('r'));
		    }
    }
	
	
	
}
?>