<?php

# This is a collection of functions useful for getting information out
# of the public (white pages) LDAP

##########################################################
#
# takes: a user id
#
# returns: an array of all publicly available info for that person
#


function getInfoForPerson($username = '')
{
  $debug = 0;

  if ($username == '')
  {
    if ($debug) { echo "\n"; }
    return 0;
  }

   //Old - taken offline by Skye 7/28/09
  //$ldap_server    = 'ldap.williams.edu';
 // $ldap_readDN    = 'cn=search,ou=people,o=williams';
  //$ldap_readPass  = 'search4it'; 
  
    //New 7/28/09
   $ldap_server    = 'idmldap2.williams.edu'  ;      //LDAP Server
   $ldap_readDN    = 'cn=wwwdirectory,ou=users,o=williams';//define("LDAP_SERVER_PORT","389");                          //LDAP Port
   $ldap_readPass  = 'search4it'; 
   $ldap_port      = 389;
  

  $link = ldap_connect($ldap_server, $ldap_port);
  if ($link)
  {
    if ($debug) { echo "connection successful\n"; }
    $bind = ldap_bind($link,$ldap_readDN,$ldap_readPass);
    if ($bind)
    {
      if ($debug) { echo "bind successful\n"; }
      $search = ldap_search($link,'ou=people,o=williams',"(uid=$username)");
      if ($search)
      {
        if ($debug) { echo "search created\n"; }
        $results = ldap_get_entries($link,$search);
        if ($results)
        {
          if ($debug) { echo "got results\n"; }
          if ($debug) { print_r($results); }
          $results_array = array();
          for ($j=0; $j < $results[0]['count']; $j++)
          {
            $results_array[$results[0][$j]] = $results[0][$results[0][$j]][0];
          }
          ldap_free_result($search);
          ldap_close($link);
          return $results_array;
        }
      }
    }
    ldap_close($link);
  }

  if ($debug) { echo "fall through - returning 0\n"; }
  return 0;
}

?>
