#!/usr/local/bin/php
<?php

$DEBUG_LEVEL = 0;
$FROM_BROWSER = 0;
$BETA_TEST = 0;

#!/usr/local/bin/php
# NOTE: the above doesn't work on unix.williams.edu

# copyright Chris Warren 2006
#

# This program constructs the email records in the DB (creating an
# email record for the current day, and linking messages to the email
# contents), marks messages in the email as published or foreshadowed
# as needed, builds the Daily Messages email texts (one per audience,
# as well as an all messages copy that doesn't actually get sent out
# but gets archived), saves a copy of each to the archives
# (i.e. updates the email record in the DB with the actual texts),
# sends each email to its appropriate audience, and deletes rejected
# messages older than a certain number of days (4, currently).

# 2006/08/15 - altered the sending part (section 4) to handle
# distribution lists and listserves (will have to make future
# alterations to support separate fac and staff listserv lists -
# currently they're combined)

# 2006/12/04 - CSW - added the cleanTextOfMSWordCharacters function
# and use thereof; also fixed the message pulling code so that the
# primary (full message) pull correctly handles foreshadow stuff
# (i.e. ignore it).

# 2007/05/29 - CSW - altered the look-ahead time intervals from 71 and
# 23 hours to 60 and 12 hours

#####################################################################
function cleanTextOfMSWordCharacters($dirty_text)
{

        $badchr = array(
           "%u2026",        // ellipsis
           "%u2014",        // long dash
           "%u2013",        // shorter long dash
           "%u2018",        // single quote opening
           "%u2019",        // single quote closing
           "%u201C",        // double quote opening
           "%u201D",        // double quote closing
           "%u2022",        // dot used for bullet points
           "%u2023",        // other shape used for bullet points
           "%uF0FC",        // other shape used for bullet points
           "%u2028",        // ????
           "%uFFFD"         // e-circumflex
           );

        $goodchr = array(
           '...',
           '-',
           '-',
           "'",
           "'",
           '"',
           '"',
           '* ',
           '* ',
           '* ',
           ' - ',
           'e'
           );

        return str_replace($badchr,$goodchr,$dirty_text);
}

#####################################################################
function verifyResult($res,$msg_on_failure,$sql)
{
  if (! $res)
  {
    if ($sql)
    {
      echo "SQL:<br>\n$sql<br>\n";
    }
    echo $msg_on_failure."<br>\n";
    echo mysql_error();
    mysql_close($connection);
    exit;
  }
}

#####################################################################
function myDebug($level,$msg)
{
  global $DEBUG_LEVEL;
  if ($DEBUG_LEVEL >= $level)
  {
    echo "$msg<br>\n";
  }
}

#####################################################################
function browserPrint($txt)
{
  global $FROM_BROWSER;
  if ($FROM_BROWSER)
  {
    echo "$txt\n";
  }
}


#####################################################################

browserPrint("<html>");
browserPrint(" <head></head>");
browserPrint(" <body>");
browserPrint("<h2>build_and_send_emails.php</h2>");

$connection = mysql_connect("mysql.williams.edu","dmweb","m3rcury");
$db_name = "dailymessages";
mysql_select_db($db_name,$connection);

# 1. Construct the email in the DB
# 1.a. create email record
# 1.b. create email contents records
# 1.b.i. mark each message as published or foreshadowed as needed

$sql_create_email_record = "INSERT INTO email VALUES (NULL,NOW(),'','','','','')";
$res_create_email = mysql_query($sql_create_email_record);
verifyResult($res_create_email,"failed to create new email",$sql_create_email_record);
$sql_get_email_id = "SELECT email_id FROM email ORDER BY email_built DESC LIMIT 1";
$res_get_email_id = mysql_query($sql_get_email_id);
verifyResult($res_get_email_id,"could not get new email_id",$sql_get_email_id);
$row_email_id = mysql_fetch_assoc($res_get_email_id);
$email_id = $row_email_id['email_id'];

# We could try to get all the messages for both publication and
# foreshadowing at once, but it's much easier to deal with the two
# things separately (likewise we could try to contruct the text as we
# go, but life is easier when we stretch it to multiple steps - this
# is not a high performance process with need for extreme speed &/|
# efficiency)

$sql_full_messages_for_email =
"SELECT m.message_id
 FROM message m
 WHERE m.category_id != 0
  AND m.refused_flag = 0
  AND m.published_flag = 0
  AND m.to_publish_flag = 1
  AND (
       IF(m.active_datetime IS NULL OR m.active_datetime = '0000-00-00 00:00:00',
          1=0,
          IF(DATE_FORMAT(m.active_datetime,'%W')='Monday',
             m.active_datetime <= DATE_ADD(NOW(), INTERVAL 60 HOUR),
             m.active_datetime <= DATE_ADD(NOW(), INTERVAL 12 HOUR)
             )
          )
       )";

$res_full_messages_for_email = mysql_query($sql_full_messages_for_email);
verifyResult($res_full_messages_for_email,"failed to get full messages for email",$sql_full_messages_for_email);

while ($row_full_message = mysql_fetch_assoc($res_full_messages_for_email))
{
  $message_id = $row_full_message['message_id'];
  $sql_add_full_message_to_email = "INSERT INTO email_content VALUES($email_id,$message_id,0)";
  $res_add_full_message_to_email = mysql_query($sql_add_full_message_to_email);
  verifyResult($res_add_full_message_to_email,"failed to add full message $message_id to email $email_id",$sql_add_full_message_to_email);
  $sql_update_message_status = "UPDATE message SET published_flag=1, publish_datetime=NOW() WHERE message_id=$message_id";
  $res_update_message_status = mysql_query($sql_update_message_status);
  verifyResult($res_update_message_status,"failed to update message to published for message $message_id",$sql_update_message_status);  
}

$sql_foreshadow_messages_for_email =
"SELECT m.message_id
 FROM message m
 WHERE
  m.refused_flag = 0
  AND m.published_flag = 0
  AND m.foreshadowed_flag = 0
  AND
  (m.to_foreshadow_flag = 1
   AND IF(m.summary_datetime IS NULL OR m.summary_datetime = '0000-00-00 00:00:00',
         1=1,
         IF(DATE_FORMAT(m.summary_datetime,'%W')='Monday',
            m.summary_datetime <= DATE_ADD(NOW(), INTERVAL 60 HOUR),
            m.summary_datetime <= DATE_ADD(NOW(), INTERVAL 12 HOUR)
            )
         )
   )";

$res_foreshadow_messages_for_email = mysql_query($sql_foreshadow_messages_for_email);
verifyResult($res_foreshadow_messages_for_email,"failed to get foreshadow messages for email",$sql_foreshadow_messages_for_email);

while ($row_foreshadow_message = mysql_fetch_assoc($res_foreshadow_messages_for_email))
{
  $message_id = $row_foreshadow_message['message_id'];
  $sql_add_foreshadow_message_to_email = "INSERT INTO email_content VALUES($email_id,$message_id,1)";
  $res_add_foreshadow_message_to_email = mysql_query($sql_add_foreshadow_message_to_email);
  verifyResult($res_add_foreshadow_message_to_email,"failed to foreshadow message $message_id in email $email_id",$sql_add_foreshadow_message_to_email);
  $sql_update_message_status = "UPDATE message SET foreshadowed_flag=1 WHERE message_id=$message_id";
  $res_update_message_status = mysql_query($sql_update_message_status);
  verifyResult($res_update_message_status,"failed to update message to foreshadowed for message $message_id",$sql_update_message_status);
}


# 2. Build the message texts
# 2.a. get all the messages, in the right order, with category info
# 2.b. add each message to the appropriate section(s) and audience(s)
# 2.c. construct full texts
# 2.c.i.  string together sections
# 2.c.ii. add headers and footers

$email_groups = array(
  'students' => 'audience_students',
  'faculty'  => 'audience_faculty',
  'staff'    => 'audience_staff',
  'other'    => 'audience_other',
  'summary'  => 'all_audience');

$last_category = array();
$headlines = array();
$details = array();
$foreshadowing = array();
$full_message_text = array();
foreach ($email_groups as $group_name => $assoc_field)
{
  $last_category[$group_name]     = '';
  $headlines[$group_name]         = '';
  $details[$group_name]           = '';
  $foreshadowing[$group_name]     = '';
  $full_message_text[$group_name] = '';
}


$DAY = array('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
$MONTH = array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
$the_time = localtime(time(),1);
$DATE_TAG = $DAY[$the_time['tm_wday']].', '.$MONTH[$the_time['tm_mon']].' '.$the_time['tm_mday'].', '.($the_time['tm_year']+1900);

$horiz_line_size = 70;
$horiz_line = '';
$email_title = "D A I L Y   M E S S A G E S";
# NOTE: the title must be the same size as the break lines! Pad with spaces.
while (strlen($horiz_line) < $horiz_line_size)
{
  $horiz_line .= '_';
  if (strlen($email_title) < $horiz_line_size)
  {
    $email_title .= ' ';
  }
}
# now replace some of the blanks on the right of the title with the date tag
$email_title = substr($email_title,0,(-1 * strlen($DATE_TAG))).$DATE_TAG;

$sql_get_footer_text = "SELECT footer_text FROM email_footer_text LIMIT 1";
$res_get_footer_text = mysql_query($sql_get_footer_text);
verifyResult($res_get_footer_text,"failed to get email footer text",$sql_get_footer_text);
$row_get_footer_text = mysql_fetch_assoc($res_get_footer_text);

$message_footer = "\n" . $row_get_footer_text['footer_text'];

$sql_message_details = "
SELECT
 c.category_name,
 m.message_id,
 m.headline,
 m.short_body,
 m.short_summary,
 m.audience_students,
 m.audience_faculty,
 m.audience_staff,
 m.audience_other,
 1 AS all_audience,
 m.to_publish_flag,
 m.published_flag,
 m.to_foreshadow_flag,
 m.foreshadowed_flag,
 e.foreshadow_flag
FROM
 message m,
 category c,
 email_content e
WHERE 1=1
 AND e.email_id = $email_id
 AND m.message_id=e.message_id
 AND c.category_id=m.category_id
ORDER BY
 e.foreshadow_flag,
 c.category_ordering,
 m.ordering";
$res_message_details = mysql_query($sql_message_details);
verifyResult($res_message_details,"failed to get message details",$sql_message_details);


$message_ordination = array(
			    'students' => 0,
			    'faculty'  => 0,
			    'staff'    => 0,
			    'other'    => 0,
			    'summary'  => 0);

while ($row_message_details = mysql_fetch_assoc($res_message_details))
{
# DEBUGGING OUTPUT
  if ($DEBUG_LEVEL > 3)
    {
      browserPrint("<pre>");
      print_r($row_message_details);
      browserPrint("</pre>");
    }
  
  myDebug(3,"handling category transitions for ".$row_message_details['message_id']);
  foreach ($email_groups as $group_name => $assoc_field)
    {
      myDebug(4,"for group $group_name, using $assoc_field");
      if ($row_message_details[$assoc_field] == 1)
	{
	  myDebug(5,"this group OK");
	  if ($row_message_details['category_name'] != $last_category[$group_name])
	    {
	      myDebug(4,"new category");
	      if (! $row_message_details['foreshadow_flag'])
		{
		  myDebug(4,"adding category to headlines");
                  #$headlines[$group_name] .= "\n\n".strtoupper($row_message_details['category_name']);
                  #$headlines[$group_name] .= "\n\n".$row_message_details['category_name'];
		  $headlines[$group_name] .= "\n\n     === ".$row_message_details['category_name']." ===";
		  if ($last_category[$group_name] != '')
		    {
		      myDebug(4,"adding breakline and category to details");
                      #$details[$group_name]   .= "\n$horiz_line\n".strtoupper($row_message_details['category_name']);
                      #$details[$group_name]   .= "\n$horiz_line\n".$row_message_details['category_name'];
		      $details[$group_name]   .= "\n\n    === ".$row_message_details['category_name']." ===";
		    } else
		    {
		      myDebug(4,"adding initial category to details");
                      #$details[$group_name]   .= strtoupper($row_message_details['category_name']);
                      #$details[$group_name]   .= "\n$horiz_line\n".strtoupper($row_message_details['category_name']);
                      #$details[$group_name]   .= "\n$horiz_line\n".$row_message_details['category_name'];
			$details[$group_name]   .= "\n\n    === ".$row_message_details['category_name']." ===";
		    }
		  $last_category[$group_name] = $row_message_details['category_name'];
		} else # $row_message_details['foreshadow_flag'] is set
		{
		  myDebug(6,"but message is foreshadowing only, so doing nothing");
		}
	    } # end if ($row_message_details['category_name'] != $last_category[$group_name])
	      
	    if (! $row_message_details['foreshadow_flag'])
	      {
		myDebug(2,"adding message to headlines and details");
		$message_ordination[$group_name]++;
		$ordination_text = $message_ordination[$group_name];
		if ($ordination_text < 10)
		  {
		    $ordination_text = " $ordination_text";
		  }
		$ordination_text .= '.';
		  
                #$headlines[$group_name] .= "\n   * ".cleanTextOfMSWordCharacters($row_message_details['headline']);
		$headlines[$group_name] .= "\n $ordination_text ".cleanTextOfMSWordCharacters($row_message_details['headline']);
                #$m_short_body = "\n".cleanTextOfMSWordCharacters($row_message_details['short_body']);
		$m_short_body = cleanTextOfMSWordCharacters($row_message_details['short_body']);
		$m_short_body = preg_replace('/\n/',"\n ",$m_short_body);
                #$details[$group_name] .= "\n$m_short_body";
		$details[$group_name] .= "\n\n$ordination_text $m_short_body";
	      } else 
	      { 
                # $row_message_details['foreshadow_flag'] is set
		myDebug(4,"adding message to foreshadowing");
		$foreshadowing[$group_name] .= "\n   * ".$row_message_details['short_summary'];
	    }
	} # end if audience valid
			      
# DEBUGGING OUTPUT
      if ($DEBUG_LEVEL > 5)
	{
	  browserPrint("<pre>\n");
	  browserPrint("\nlast_category $group_name\n");
	  browserPrint($last_category[$group_name]);
	  browserPrint("\nheadlines $group_name\n");
	  browserPrint($headlines[$group_name]);
	  browserPrint("\ndetails $group_name\n");
	  browserPrint($details[$group_name]);        
	  browserPrint("\nforeshadowing $group_name\n");     
	  browserPrint($foreshadowing[$group_name]);     
	  browserPrint("\nfull_message_text $group_name\n"); 
	  browserPrint($full_message_text[$group_name]); 
	  browserPrint("</pre>\n");
	}
 
    } # end foreach group
	
} # end while rows
	

foreach ($email_groups as $group_name => $assoc_field)
{
  if ((strlen($details[$group_name]) > 0) || (strlen($foreshadowing[$group_name])> 0))
    { # if there's anything to publish for this group

    $full_message_text[$group_name] = "$horiz_line\n\n$email_title\n$horiz_line";

    if (strlen($details[$group_name]) > 0)
    {
      #$full_message_text[$group_name] .= "$headlines[$group_name]\n";
      $full_message_text[$group_name] .= "$headlines[$group_name]\n$horiz_line";
    }

    if (strlen($foreshadowing[$group_name]) > 0)
    {
      $full_message_text[$group_name] .= "\nUPCOMING$foreshadowing[$group_name]\n";
    }

    $full_message_text[$group_name] .= "$details[$group_name]\n$horiz_line";
    $full_message_text[$group_name] .= "\n$message_footer";

  } # end if there's anything to publish for this group

  # DEBUGGING OUTPUT
  if ($DEBUG_LEVEL > 1)
  {
    browserPrint("<hr>\n<pre>".$group_name."\n");
    browserPrint($full_message_text[$group_name]);
    browserPrint("</pre>\n<hr>\n");
  }
}

# 3. save full text messages back to the archives
# 3.a. prepare each message text to be saved (escape quotes)
# 3.b. do the save (update) to the DB

foreach ($email_groups as $group_name => $assoc_field)
{
  $full_message_text[$group_name] = preg_replace('/\'/',"''",$full_message_text[$group_name]);
}

$sql_save_message_texts = "
UPDATE email
SET 
 text_for_students='".$full_message_text['students']."',
 text_for_faculty='".$full_message_text['faculty']."',
 text_for_staff='".$full_message_text['staff']."',
 text_for_other='".$full_message_text['other']."',
 text_for_all_combined='".$full_message_text['summary']."'
WHERE
email_id=$email_id";

myDebug(4,"update sql is:\n$sql_save_message_texts");

$res_save_message_texts = mysql_query($sql_save_message_texts);
verifyResult($res_save_message_texts,"could not save message texts back to DB for email $email_id",$sql_save_message_texts);


# 4. actually send out the emails to the appropriate addresses
# 4.a. create the sender and email subject
# 4.b. first handle the listserv lists
# 4.b.1. define the destination addresses
# 4.b.2. create any full message entries necessary (fac -> other-fac and staff -> other-staff)
# 4.b.3. send the messages
#4.c. second handle the distribution lists
# 4.c.1. for each target
# 4.c.1.a. define the special headers
# 4.c.1.b. define the targets
# 4.c.1.c. send the messages

$email_from = 'message@williams.edu';
$email_subject = "Daily Messages for $DATE_TAG";
$email_other_headers = "From: $email_from\r\n";

$email_group_addresses = array(
  'summary'        => 'dm-all-l@williams.edu',
  'other-faculty'  => 'dm-subscription-l@williams.edu'
);
# other fac and staff are not separate yet, so the combined group gets just the fac for the moment

# 2006/08/15 - added for list serv distribution, makes approp copies
$full_message_text['other-faculty'] = $full_message_text['faculty'];
$full_message_text['other-staff'] = $full_message_text['staff'];



# 2006/08/15 - WARNING: this BETA code may be defunct with the distrib list model....
if ($BETA_TEST)
{
  $email_group_addresses = array(
    'students' => 'Chris.Warren@williams.edu',
    'faculty'  => 'Chris.Warren@williams.edu',
    'staff'    => 'Chris.Warren@williams.edu',
    'other'    => 'Chris.Warren@williams.edu',
    'summary'  => 'Chris.Warren@williams.edu'
  );
}


foreach ($email_group_addresses as $group_name => $group_address)
{
  # remove the quote escaping done for the SQL
  $full_message_text[$group_name] = preg_replace('/\'\'/',"'",$full_message_text[$group_name]);

  # only send it out if there's something to send
  if (preg_match('/\S/',$full_message_text[$group_name]))
  {
    $local_subject = $email_subject;
    if (($BETA_TEST) || ($DEBUG_LEVEL >= 1))
    {
      $local_subject = "DM beta test - $local_subject - $group_name edition";
    }
    mail($group_address,$local_subject,$full_message_text[$group_name],$email_other_headers);
  }
}

# the distribution lists are handled differently. Rather than being
# mailed directly to a list alias their sent to a remailer
# (mailer@distribution.williams.edu) which checks for various special
# headers (Fromline, Target, Authcode) and sends the message along to
# the group specified by the Target header.

$email_distribution_to = 'mailer@distribution.williams.edu';

$email_group_distribution_targets = array(
  'students' => 'williams-students',
  'faculty'  => 'williams-faculty',
  'staff'    => 'williams-staff'
);

foreach ($email_group_distribution_targets as $group_name => $group_target)
{
  # remove the quote escaping done for the SQL
  $full_message_text[$group_name] = preg_replace('/\'\'/',"'",$full_message_text[$group_name]);
  
  # only send it out if there's something to send
  if (preg_match('/\S/',$full_message_text[$group_name]))
  {
    $local_subject = $email_subject;
    if (($BETA_TEST) || ($DEBUG_LEVEL >= 1))
    {
      $local_subject = "DM beta test - $local_subject - $group_name edition";
    }

    $email_other_headers = "From: $email_from\r\n";
    $pseudo_headers = "Fromline: $email_from\nTarget: $group_target\nAuthcode: onefineday\n\n";

    mail($email_distribution_to,$local_subject,$pseudo_headers.$full_message_text[$group_name],$email_other_headers);
  }
}


# 5. clean up rejected messages
# 5.a. delete messages that are refused and are older than 2 days (48 hours)

$sql_delete_old_refused_messages =
"DELETE FROM
message
WHERE
refused_flag = 1
AND
DATE_ADD(datetime_created, INTERVAL 48 HOUR) < NOW()";

#"SELECT
#message_id
#FROM
#message
#WHERE
#refused_flag = 1
#AND
#DATE_ADD(datetime_created, INTERVAL 96 HOUR) < NOW()";

$res_delete_old_refused_messages = mysql_query($sql_delete_old_refused_messages);
verifyResult($res_delete_old_refused_messages,"Could not delete old messages",$sql_delete_old_refused_messages);

#while ($row_delete_old_refused_messages = mysql_fetch_row($res_delete_old_refused_messages))
#{
#  myDebug(1,"message to delete is $row_delete_old_refused_messages[0]");
#  
#}

mysql_close($connection);
?>
