<?php 

include_once("/web/messages/testing/include/authentication.php");
include_once("/web/messages/testing/include/ldap_queries.php");
include_once("/web/messages/testing/include/db.php"); 
if(!$_SESSION['authenticated']) {
 header("Location: http://$host$uri/login");
}

$submission_confirmation = 'Your message has been submitted.<br />You will receive an email confirmation as to whether or not your Daily Message has been submitted.';



#######################################################

# takes: a string
# returns: some HTML for the user about the error ecountered and what to do
function errorResponse($the_err_msg)
{
  $resp = 
"
<br><br>
The system ran into a problem. Please send the following info (cut and
paste into your email) to Chris.Warren@williams.edu:<pre>

$the_err_msg

  submitter_userid   = {$_POST['submitter_userid']}
  submitter_name     = {$_POST['submitter_name']}
  submitter_email    = {$_POST['submitter_email']}
  submitter_phone    = {$_POST['submitter_phone']}

  submitter_org      = {$_POST['submitter_org']}

  audience_student   = {$_POST['audience_student']}
  audience_faculty   = {$_POST['audience_faculty']}
  audience_staff     = {$_POST['audience_staff']}

  headline           = {$_POST['headline']}
  short_body         = {$_POST['formatted_message']}
  long_body          = {$_POST['longbody']}
  active_date        = {$_POST['active_date']}

</pre>
Thank you, and sorry for the inconvenience.";

  return $resp;
}


#######################################################

function cleanTextOfMSWordCharacters($dirty_text)
{

        $badchr = array(
           "%u2026",        // ellipsis
           "%u2014",        // long dash
           "%u2013",        // shorter long dash
           "%u2018",        // single quote opening
           "%u2019",        // single quote closing
           "%u201C",        // double quote opening
           "%u201D",        // double quote closing
           "%u2022",        // dot used for bullet points
           "%uF0FC",         // other shape used for bullet points
           "%uFFFD"         // e-circumflex
           );

        $goodchr = array(
           '...',
           '-',
           '-',
           "'",
           "'",
           '"',
           '"',
           '* ',
           '* ',
           'e'
           );

        return str_replace($badchr,$goodchr,$dirty_text);
}

#######################################################

/*
session_set_cookie_params(60*60*2); # two hour sessions
session_start();

if ($_POST['cancel_message'])
{
  $_SESSION['authenticated'] = 0;
  $message = 'Message cancelled.';
}

if (! $_SESSION['authenticated'])
{
  session_write_close();
  $host  = $_SERVER['HTTP_HOST'];
  $uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
  $login_page = 'index.php';
  if (! $message) { $message = 'Your username - password combination was not valid.'; }
  header("Location: https://$host$uri/$login_page?login_message=".urlencode($message));
  exit;
} else # session IS authenticated
{

  $_SESSION['authenticated'] = 0;
*/
  $date_default_value=quote_smart('----/--/--');

  # get the form data
  $submitter_userid = quote_smart($_POST['submitter_userid']);
  $submitter_name   = quote_smart($_POST['submitter_name']);
  $submitter_email  = quote_smart($_POST['submitter_email']);
  $submitter_phone  = quote_smart($_POST['submitter_phone']);

  $submitter_org      = quote_smart($_POST['submitter_org']);
  $audience_student   = quote_smart($_POST['audience_student']=='on'?1:0);
  $audience_faculty   = quote_smart($_POST['audience_faculty']=='on'?1:0);
  $audience_staff     = quote_smart($_POST['audience_staff']=='on'?1:0);
  $audience_other     = quote_smart($_POST['audience_other']=='on'?1:0);
  $audience_extra1    = 0;
  $audience_extra2    = 0;
  $headline           = cleanTextOfMSWordCharacters(quote_smart($_POST['headline']));
  $short_body         = cleanTextOfMSWordCharacters(quote_smart($_POST['formatted_message']));
  $long_body          = cleanTextOfMSWordCharacters(quote_smart($_POST['longbody']));
  $active_date        = quote_smart($_POST['active_date'])==$date_default_value?'NULL':quote_smart($_POST['active_date']);
  $short_summary      = "''";
  $summary_datetime   = "''";
  $submitter_comment  = "''";
  $refused_flag       = 0;
  $to_publish_flag    = 0;
  $published_flag     = 0;
  $to_foreshadow_flag = 0;
  $foreshadowed_flag  = 0;
  $category_id        = 0;
  $ordering           = 6;
  $admin_comment      = '';

  $sql_message_insert = "INSERT INTO message VALUES (NULL,NOW(),$submitter_userid,$submitter_name,$submitter_email,$submitter_phone,$submitter_org,$audience_student,$audience_faculty,$audience_staff,$audience_other,$audience_extra1,$audience_extra2,$headline,$short_body,$long_body,$active_date,$short_summary,$summary_datetime,$submitter_comment,$refused_flag,$to_publish_flag,$published_flag,NULL,$to_foreshadow_flag,$foreshadowed_flag,$category_id,$ordering,'$admin_comment')";

  $response_to_user = '';

  # the locking ensure that when we do the select to get the last insert id we get the right one
  mysql_query("LOCK TABLES message,email,email_content,category WRITE");
  mysql_query("SET AUTOCOMMIT = 0");
  $result = mysql_query($sql_message_insert);
  $res_last_insert_id = mysql_query("SELECT LAST_INSERT_ID()");
  mysql_query("COMMIT");
  mysql_query("UNLOCK TABLES");

  if ($result)
  {
    $response_to_user = $submission_confirmation;// 'Your message has been submitted.';

    $email_from = 'message@williams.edu';
    $email_subject = "Daily message submitted - '$headline'";
    $email_other_headers = "From: $email_from\r\nBcc: sjohnso2@williams.edu\r\n";
    $email_to = $submitter_email;
    $to_name = $submitter_name;

    $email_message_text = "
$to_name,

  Your Daily Messages has been submitted, but not yet been 
either accepted or rejected. You will receive another email 
when that happens. If you have not received such a messaged 
by 3 PM of the workday before your message is to run, then 
please contact Jo Procter directly.

------

$short_body

------

$long_body
";

    # goes to developer for testing (second line) and submitter when live (first line)
    mail($email_to,$email_subject,$message_text,$email_other_headers);

    # now update the message to put the correct ID in the URL, if needed
    if ($long_body)
    {
      $row_last_insert_id = mysql_fetch_row($res_last_insert_id);
      $message_id = $row_last_insert_id[0];
      $short_body = preg_replace('/\?id=123456/',"?id=$message_id",$short_body);
      $sql_message_update = "UPDATE message SET short_body=$short_body WHERE message_id=$message_id";
      # DEBUGGING!
      #$response_to_user = "Your message has been submitted as message $message_id.<br>$sql_message_update";
      $res_message_update = mysql_query($sql_message_update);
      if (! $res_message_update)
      {
        $response_to_user .= errorResponse('On UPDATE: ' . mysql_error());
      }
    }
  }
  else # no result
  {
    $response_to_user .= errorResponse("On INSERT: \n" . mysql_error());
  }

 // include("/web/messages/testing/include/DM_head.php");

include("/web/messages/testing/include/DM_head.php");

?>

  <script language="JavaScript">
//<![CDATA[

  function onLoadHandler()
  {
  }

//]]>
  </script>

<table id="showMessages" width="100%" border="0" cellspacing="0" cellpadding="0" align="center" summary="table">
  <tr>
  <td valign="top" width="570" >
    <div id="date_heading">Daily Messages Submission Confirmation</div>
    <p style="margin-left:15px;"><?=$response_to_user?></p>
  
  </td>
   <td valign="top" id="sidecolumn" width="200" ><?php include("/web/messages/testing/include/DM_sidecolumn.php"); ?></td>
 </tr>
</table>
<?php
//} # end session IS authenticated

include("/web/messages/testing/include/DM_foot.php"); 

?>
