<?php

# These are various functions used in the admin daily messages tool,
# plus a bit of prelim code to ensure the functions have all the data
# they need

$sql_categories = 'SELECT category_id, category_name FROM category ORDER BY category_ordering';
$categories_result = mysql_query($sql_categories,$connection);
$categories_array = array();
$num_categories = 0;
while ($categ_row = mysql_fetch_assoc($categories_result))
{
  $categories_array[$num_categories] = $categ_row;
  $num_categories++;
}

#--------------------------------------------------------------------
# takes a category ID

# returns a string that has the HTML for options (e.g. for a select
# field) for possible message categories, with the passed in category
# pre-selected

function generateCategoriesListing($selected_category_id)
{
  global $categories_array;
  $built_categories_list = '<option class="alert_color" value="0">-- Select a Category --'."\n";
  foreach ($categories_array as $cr)
  {
    if ($cr['category_id']==$selected_category_id)
    {
      $built_categories_list .= "<option class=\"normal_color\" value=\"{$cr['category_id']}\" selected>{$cr['category_name']}\n";
    } else {
      $built_categories_list .= "<option class=\"normal_color\" value=\"{$cr['category_id']}\">{$cr['category_name']}\n";
    }
  }
  return $built_categories_list;
}

#--------------------------------------------------------------------
# takes an ordering number

# returns a string that has the HTML for options (e.g. for a select
# field) for possible ordering values, with the passed in value
# pre-selected

function generateOrderingListing($selected_order)
{
  if (! $selected_order)
  {
    $selected_order = 6;
  }
  $built_ordering_list = '';
  for ($o = 1; $o <= 11; $o++)
  {
    if ($o==$selected_order)
    {
      $built_ordering_list .= "<option value=\"{$o}\" selected>{$o}\n";
    } else {
      $built_ordering_list .= "<option value=\"{$o}\">{$o}\n";
    }
  }
  return $built_ordering_list;
}


#--------------------------------------------------------------------
# returns the text to use for the status of accepted messages
function getAcceptedStatusText()
{
  return "message accepted";
}


#--------------------------------------------------------------------
# returns the text to use for the status of rejected messages
function getRejectedStatusText()
{
  return "message rejected";
}


#--------------------------------------------------------------------
# returns the text to use for the status of held messages
function getHeldStatusText()
{
  return "message on hold";
}


#--------------------------------------------------------------------
# cleans unicode characters out of text
# returns the cleaned text
function cleanTextOfMSWordCharacters($dirty_text)
{
        $badchr = array(
           "%u2026",        // ellipsis
           "%u2014",        // long dash
           "%u2013",        // shorter long dash
           "%u2018",        // single quote opening
           "%u2019",        // single quote closing
           "%u201C",        // double quote opening
           "%u201D",        // double quote closing
           "%u2022",        // dot used for bullet points
           "%u2023",        // dot used for bullet points
           "%uF0FC",         // other shape used for bullet points
           "%u2028",        // ????
           "%uFFFD"         // e-circumflex
           );

        $goodchr = array(
           '...',
           '-',
           '-',
           "'",
           "'",
           '"',
           '"',
           '* ',
           '* ',
           '* ',
           ' - ',
           'e'
           );

        return str_replace($badchr,$goodchr,$dirty_text);
}


#--------------------------------------------------------------------
# takes a whole bunch of message info, plus a flag indicating whether
# or not the display to be generated is for a foreshadowing
# (i.e. Upcoming section) message

# returns the HTML necessary to display the message, with the buttons
# to control it (OK or NO or hold)

function generateMessageDisplay
  ($message_id, $datetime_created, 
   $submitter_user_id, $submitter_name, $submitter_phone, $submitter_email, $submitter_org,
   $audience_students, $audience_faculty, $audience_staff, $audience_other, $audience_extra1, $audience_extra2,
   $headline, $shortbody, $longbody, 
   $active_datetime, $shortsummary, $summary_datetime,
   $submitter_comment,
   $refused_flag,
   $published_flag,
   $foreshadowed_flag,
   $admin_comment,
   $to_publish_flag, $to_foreshadow_flag, $category_id, $ordering, $FOR_FORESHADOWING)
{

  $OK_button_action = 'accept';
  $NO_button_action = 'reject';
  $hold_button_action = 'hold';

  $headline = cleanTextOfMSWordCharacters($headline);
  $shortbody = cleanTextOfMSWordCharacters($shortbody);
  $longbody = cleanTextOfMSWordCharacters($longbody);

  #preg_replace('/\"/\'/',$headline);
  $dq = array('"');
  $dqr = array("''");
  $headline = str_replace($dq,$dqr,$headline);

  $message_indicator_id = 'message_indicator_'.$message_id.'_ID';
  $message_indicator_text_id = 'message_indicator_text_'.$message_id.'_ID';

  $message_indicator_class = 'undecided_message';
  $message_indicator_text = '?';
  if ($refused_flag)
  {
    $message_indicator_class = 'rejected_message';
    $message_indicator_text = getRejectedStatusText();
  } else if ($to_publish_flag)
  {
    $message_indicator_class = 'accepted_message';
    $message_indicator_text = getAcceptedStatusText();
  } else
  {
    $message_indicator_class = 'undecided_message';
    $message_indicator_text = getHeldStatusText();
  }

  $message_display = '';

  $message_display .= "
<tr>
<td class=\"admin_lefthand_col\">
<hr><br />
<center>
";

  if (! $category_id)
  {
    $message_display .= "<select class=\"alert_color\" name=\"category_select_{$message_id}\" id=\"category_select_{$message_id}_ID\" onChange=\"handleCategorySelection(this); actOnMessage({$message_id},'save');\">";
  } else
  {
    $message_display .= "<select name=\"category_select_{$message_id}\" id=\"category_select_{$message_id}_ID\" onChange=\"handleCategorySelection(this); actOnMessage({$message_id},'save');\">";
  }
  $message_display .= generateCategoriesListing($category_id);
  $message_display .= "</select><br />
Order in category: <select name=\"ordering_{$message_id}\" id=\"ordering_{$message_id}_ID\" onChange=\"actOnMessage({$message_id},'save');\">";
  $message_display .= generateOrderingListing($ordering);
  $message_display .= "</select><br />
<br />
<input class=\"ok_button\" type=\"button\" value=\"OK to publish\" onclick=\"actOnMessage($message_id,'$OK_button_action');\"><br />
<br />
<b>Rejection Comment/Reason</b><br />
<textarea name=\"admin_comment_{$message_id}\" id=\"admin_comment_{$message_id}_ID\"\" rows=\"5\" cols=\"25\" 
style=\"width:180px;\">{$admin_comment}</textarea><br />
<br />
<b><input class=\"no_button\" type=\"button\" value=\"NO, reject this\" onclick=\"actOnMessage($message_id,'$NO_button_action');\"><br />
<br />
<input class=\"hold_button\" type=\"button\" value=\"hold for later\" onclick=\"actOnMessage($message_id,'$hold_button_action');\"><br />
<br />
<br />
<input type=\"button\" value=\"save changes\" onclick=\"actOnMessage($message_id,'save');\"><br />

</center>

</td>
<td class=\"admin_righthand_col\">
<hr><br />

<center>
<b>Message Status</b>
<table width=\"95%\">
 <tr>
  <td style=\"border: solid black 1px;\" class=\"$message_indicator_class\" id=\"$message_indicator_id\" >
<br />
<center><span class=\"big_text\" id=\"$message_indicator_text_id\">$message_indicator_text</span></center>
<br />
  </td>
 </tr>
</table>
</center>
<br />

<b>Message date:</b> $active_datetime
<br />
<br />
<b>From:</b>  $submitter_name, $submitter_org, <span id=\"datetime_created_{$message_id}_ID\">$datetime_created</span><br />
($submitter_user_id, $submitter_email, $submitter_phone)<br />
<br />";

  $audience_list = '';
  $audience_list .= getAudienceCode ($message_id, $audience_students, 'students', 'Students');
  $audience_list .= getAudienceCode ($message_id, $audience_faculty, 'faculty', 'Faculty');
  $audience_list .= getAudienceCode ($message_id, $audience_staff, 'staff', 'Staff');

#  if ($audience_students)
#  {
#    $audience_list .= '<input type="checkbox" name="" checked /><span class="audience_list_selected" id="">Students  </span>';
#  } else {
#    $audience_list .= '<input type="checkbox" name="" /><span class="audience_list_not_selected id=""">Students  </span>';  
#  }
#  if ($audience_faculty)
#  {
#    $audience_list .= '<input type="checkbox" name="" checked /><span class="audience_list_selected id=""">Faculty  </span>';
#  } else {
#    $audience_list .= '<input type="checkbox" name="" /><span class="audience_list_not_selected id=""">Faculty  </span>';
#  }
#  if ($audience_staff)
#  {
#    $audience_list .= '<input type="checkbox" name="" checked /><span class="audience_list_selected" id="">Staff  </span>';
#  } else {
#    $audience_list .= '<input type="checkbox" name="" /><span class="audience_list_not_selected" id="">Staff  </span>';
#  }
#  if ($audience_other)
#  {
#    $audience_list .= '<span class="audience_list_selected">Affiliates  </span>';
#  } else {
#    $audience_list .= '<span class="audience_list_not_selected">Affiliates  </span>';
#  }
  $message_display .= "
<b>To:</b> <span class=\"audience_list\">$audience_list</span>
<br />
<br />
<b>Headline:</b> <input name=\"headline_{$message_id}\" id=\"headline_{$message_id}_ID\" type=\"text\" size=\"55\" maxlength=\"65\" value=\"$headline\" autocomplete=\"off\" onfocus=\"pseudoDisable(this);\"><br />
<br />
<b>Message:</b><br /><!-- style=\"font-family: monaco, monospace; font-size: 8pt;\"  -->
<textarea name=\"shortbody_{$message_id}\" id=\"shortbody_{$message_id}_ID\" rows=\"8\" cols=\"71\" autocomplete=\"off\" wrap=\"off\" style=\"width: 480px;\">$shortbody</textarea>
<br />
<br />";
  if ($longbody)
  {
    $message_display.= "
<b>Long message:</b><br />
<textarea name=\"longbody_{$message_id}\" id=\"longbody_{$message_id}_ID\" rows=\"12\" cols=\"71\" autocomplete=\"off\" wrap=\"on\" style=\"width: 480px;\">$longbody</textarea>";
  } 
  $message_display .= "
</td>
</tr>";


  return $message_display;
}

#--------------------------------------------------------------------
# takes: a message_id, an audience flag, and audience label for creating an ID (e.g. student), and an audience label for humans to read (e.g. Student)
# returns: an HTML string for that audience for the message moderation page
function getAudienceCode ($message_id, $audience_flag, $audience_id_label, $audience_human_label)
{
  $audience_code = '';
  $checkbox_name = "cb_{$message_id}_{$audience_id_label}";
  $checkbox_id   = "{$checkbox_name}_ID";
  $span_id       = "audience_text_{$message_id}_{$audience_id_label}";
  if ($audience_flag)
    {
      $checked_text = 'checked';
      $span_class = 'audience_list_selected';
    } else {
      $checked_text = '';
      $span_class = 'audience_list_not_selected';
    }
  $audience_code .= "<input type=\"checkbox\" name=\"$checkbox_name\" id=\"$checkbox_id\" $checked_text onclick=\"handleAudienceCheck(this,'$message_id','$audience_id_label');\" />";
  $audience_code .= "<span class=\"$span_class\" id=\"$span_id\">$audience_human_label  </span>";
  return $audience_code;
}

#--------------------------------------------------------------------
# takes nothing

# returns the SQL for the beginning of a select statement to get all
# the data from a message row. The FROM, WHERE, and ORDER clauses are
# added in the called code.

function generateMessageSelectStart()
{
  $select_start =
"SELECT
m.message_id,
m.datetime_created,
m.submitter_userid ,
m.submitter_name ,
m.submitter_email ,
m.submitter_phone ,
m.submitter_org,
m.audience_students,
m.audience_faculty ,
m.audience_staff,
m.audience_other,
m.audience_extra1 ,
m.audience_extra2,
m.headline,
m.short_body,
m.long_body ,
DATE_FORMAT(m.active_datetime,'%a, %b %d') AS active_datetime,
m.short_summary,
DATE_FORMAT(m.summary_datetime,'%a, %b %d') AS summary_datetime,
m.submitter_comment,
m.refused_flag,
m.to_publish_flag,
m.published_flag,
m.to_foreshadow_flag,
m.foreshadowed_flag,
m.category_id,
m.ordering,
m.admin_comment";

  return $select_start;
}


?>
