<?php 

session_set_cookie_params(60*60*2); # two hour sessions
session_start();

include_once("../include/db.php");
include_once("/web/messages/admin/include/authenticate.php");

if (! $_SESSION['authenticated'])
{
  $incoming_username = preg_replace('/^\'|\'$/','',quote_smart($_POST['username']));
  $incoming_password = preg_replace('/^\'|\'$/','',quote_smart($_POST['password']));
  $_SESSION['authenticated'] = authenticateAgainstDMAdmin($incoming_username,$incoming_password);
  $_SESSION['userid'] = $incoming_username;
}

if (! $_SESSION['authenticated'])
{
  session_write_close();
  $host  = $_SERVER['HTTP_HOST'];
  $uri  = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
  $login_page = 'index.php';
  $message = 'Your username - password combination was not valid.';
  header("Location: https://$host$uri/$login_page?login_message=".urlencode($message));
  exit;
} 

# else auth OK, so go ahead with the regular stuff

 include("../include/DM_head.php");
 include_once("/web/messages/admin/include/admin_functions.php");

$sql_categories = 'SELECT category_id, category_name FROM category ORDER BY category_ordering';
$categories_result = mysql_query($sql_categories,$connection);
$categories_array = array();
$num_categories = 0;
while ($categ_row = mysql_fetch_assoc($categories_result))
{
  $categories_array[$num_categories] = $categ_row;
  $num_categories++;
}


$sql_all_messages = generateMessageSelectStart()."
FROM 
message m left outer join category c on c.category_id=m.category_id
WHERE
m.published_flag = 0
ORDER BY
m.refused_flag,
ifnull(m.active_datetime,NOW()),
(IF(m.to_publish_flag+m.to_foreshadow_flag+m.refused_flag < 1,1000,0) + (m.to_publish_flag*100)) desc,
ifnull(c.category_ordering,0) asc,
ifnull(c.category_name,'a') asc,
m.ordering asc
";

$result = mysql_query($sql_all_messages);

$message_ar = array();
$message_counter = 0;

while ($row =  mysql_fetch_assoc($result))
{
  $message_ar[$message_counter] = generateMessageDisplay(
   $row['message_id'], $row['datetime_created'],
   $row['submitter_userid'], $row['submitter_name'], $row['submitter_phone'], $row['submitter_email'], $row['submitter_org'],
   $row['audience_students'], $row['audience_faculty'], $row['audience_staff'], $row['audience_other'], 
   $row['audience_extra1'], $row['audience_extra1'],
   $row['headline'],
   $row['short_body'],
   $row['long_body'],
   $row['active_datetime'], $row['short_summary'], $row['summary_datetime'],
   $row['submitter_comment'],
   $row['refused_flag'],
   $row['published_flag'],
   $row['foreshadowed_flag'],
   $row['admin_comment'],
   $row['to_publish_flag'], $row['to_foreshadow_flag'], $row['category_id'], $row['ordering'],
   0);

  $message_counter++;
}

?>

<script src="ajax/xmlhttpreq.js"></script>

<script language="JavaScript">
//<![CDATA[

  function onLoadHandler()
  {
    //document.getElementById("message_summary_ID").pseudoDisableState = true;
  }

  function handleCategorySelection(elt)
  {
    if (elt.value==0)
    {
      elt.className="alert_color";
    }
    else
    {
      elt.className="normal_color";
    }
  }

  function handleAudienceCheck(elt,message_id,audience_id)
  {
    var textElt = document.getElementById("audience_text_"+message_id+"_"+audience_id);
    if (elt.checked)
    {
      textElt.className="audience_list_selected";
    }
    else
    {
      textElt.className="audience_list_not_selected";
    }
  }

  // a replacement for true disabling. With this method the 'disabled' fields are still submitted.
  function pseudoDisable(eltX)
  {
    if (eltX.pseudoDisableState == true)
    {
      eltX.blur();
    }
  }

  function actOnMessage(message_id,action)
  {
    var url = '';
    if (action == 'accept')
    {
      var categ_id = document.getElementById("category_select_"+message_id+"_ID").value;
      if (categ_id == 0)
      {
        alert("The message needs a category before it can be accepted");
        document.getElementById("category_select_"+message_id+"_ID").focus();
      } 
	  else
      {
        document.getElementById("message_indicator_"+message_id+"_ID").className = "accepted_message";
        document.getElementById("message_indicator_text_"+message_id+"_ID").innerHTML = '<?php echo getAcceptedStatusText(); ?>';
		alert('sending accept e-mail...');
        url = 'ajax/accept.php?';
      }
    } 
	
	else if (action == 'hold') 
    {
      document.getElementById("message_indicator_"+message_id+"_ID").className = "undecided_message";
      document.getElementById("message_indicator_text_"+message_id+"_ID").innerHTML = '<?php echo getHeldStatusText(); ?>';
      url = 'ajax/hold.php?';
    } else if (action == 'save') 
    {
      url = 'ajax/save.php?';
    } else 
    {
	  if (document.getElementById("admin_comment_"+message_id+"_ID").value.length < 2)
	  {
		alert("A comment is required to reject a message");
	 	document.getElementById("admin_comment_"+message_id+"_ID").focus();
	    return;
      }
      document.getElementById("message_indicator_"+message_id+"_ID").className = "rejected_message";
      document.getElementById("message_indicator_text_"+message_id+"_ID").innerHTML = '<?php echo getRejectedStatusText(); ?>';
      url = 'ajax/reject.php?';
    }

    if (url)
    {
      var qs = buildQueryStringForMessage(message_id);
	 // alert("DEBUG MESSAGE FROM SKYE \n"+url+qs);
      //
      //alert("calling "+url+qs);
      //var uwin = window.open('empty.html','uwin');
      //uwin.document.write(url+qs);
      //
      loadXMLDoc(url+qs);
    }
  }

  function buildQueryStringForMessage(message_id)
  {
    var q = '';
    q += 'message_id='+message_id;
	q += '&datetime_created='+document.getElementById("datetime_created_"+message_id+"_ID").innerHTML; //Added by Skye 4/8/08
    q += '&category_id='+document.getElementById("category_select_"+message_id+"_ID").value;
    q += '&ordering='+document.getElementById("ordering_"+message_id+"_ID").value;
    q += '&admin_comment='+escape(document.getElementById("admin_comment_"+message_id+"_ID").value);
    q += '&headline='+escape(document.getElementById("headline_"+message_id+"_ID").value);
    q += '&shortbody='+escape(document.getElementById("shortbody_"+message_id+"_ID").value);
    if (document.getElementById("longbody_"+message_id+"_ID") != null)
    {
      q += '&longbody='+escape(document.getElementById("longbody_"+message_id+"_ID").value);
    }
    if (document.getElementById("message_summary_"+message_id+"_ID") != null)
    {
      q += '&message_summary='+escape(document.getElementById("message_summary_"+message_id+"_ID").value);
    }

    if (document.getElementById("cb_"+message_id+"_students_ID").checked)
    {
      q += '&audience_students=1';
    } else
    {
      q += '&audience_students=0';
    }

    if (document.getElementById("cb_"+message_id+"_faculty_ID").checked)
    {
      q += '&audience_faculty=1';
    } else
    {
      q += '&audience_faculty=0';
    }

    if (document.getElementById("cb_"+message_id+"_staff_ID").checked)
    {
      q += '&audience_staff=1';
    } else
    {
      q += '&audience_staff=0';
    }

    return q;
  }

  function confirmAjax(ajaxResponse)
  {
    if (ajaxResponse == '')
    {
      alert("No ajax response");
    }
    else
    {
      //alert("Ajax response: "+ajaxResponse);
    }
  }

//]]>
</script>

<?php 
include("/web/messages/admin/include/admin_nav_bar.php"); 
include("../include/740_HR_table.php"); 
?>

<table class="admin_content_table" cellspacing="0" summary="table">
 <tr>
  <td class="admin_lefthand_col"></td>
  <td class="admin_righthand_col">
<br /><br />
<b>MODERATE DAILY MESSAGES</b><br />
  </td>
 </tr>

<?php
if ($message_counter < 1)
{
    echo "<tr><td class=\"admin_lefthand_col\"></td><td class=\"admin_righthand_col\">No messages to moderate</td></tr>";
} else
{
  for ($mi = 0; $mi <= $message_counter; $mi++)
  {
    echo $message_ar[$mi];
  }
}
?>

</table>

<?php 

include("../include/DM_foot.php"); 

?>
