<?
require_once($_SERVER['DOCUMENT_ROOT']."/includes/_williams-lib.php");//include constants/server variables
require_once("/web/includes/database/messages-connect.php");
require_once("/web".PHPMAILER);

$support_email  = "sjohnso2@williams.edu";
$limit          =  25; //Show only the most recent 20 messages


// ----------------------------------------------------------------------------
//  Title:  Daily Messages: Database Functions
//
//  Author: Skye Johnson
//
// ----------------------------------------------------------------------------

if(!function_exists('quote_smart')) { 
function quote_smart($value) 
{
   // Stripslashes
   if (get_magic_quotes_gpc()) 
   {
       $value = stripslashes($value);
   }
   // Quote if not integer
   if (!is_numeric($value) || $value[0] == '0') 
   {
       $value = "'" . mysql_real_escape_string($value) . "'";
   }
   return $value;
 }
}


if(!function_exists('cleanMessage')) {
function cleanMessage($message) {

 
	$badchr = array(
	   "%u2026",        // ellipsis
	   "%u2014",        // long dash
	   "%u2013",        // shorter long dash
	   "%u2018",        // single quote opening
	   "%u2019",        // single quote closing
	   "%u201C",        // double quote opening
	   "%u201D",        // double quote closing
	   "%u2022",        // dot used for bullet points
	   "%uF0FC",         // other shape used for bullet points
	   "%uFFFD"         // e-circumflex
	   );
	   

	$goodchr = array(
	   '...',
	   '-',
	   '-',
	   "'",
	   "'",
	   '"',
	   '"',
	   '* ',
	   '* ',
           'e'
	   );

	$clean_message = str_replace($badchr,$goodchr,$message);
return $clean_message;
  // return wordwrap($clean_message,75);
}
}


if(!function_exists('liveLinks')) {
function liveLinks($message) {
 return preg_replace(
    '/(http\:\/\/\S+)/',
    '<a href="$1">$1</a>',
    $message);
  }
}

  



if(!function_exists('shorten')) {
//Takes a string and cuts it off at the desired length with an ellipsis
function shorten($string,$length,$end="...")
{
   return (strLen($string)>$length)?subStr($string,0,$length-strLen($end)).$end:
   $string;
}

}

if(!function_exists('getUpdateStatement')) {
	function getUpdateStatement($table,$primary_id,$id_value,$array)
	{
		 $update_info = " UPDATE " . $table  . " SET ";
		 foreach($array as $field=>$value) $update_info.= $field."=".$value.",";
		 $update_info = rtrim($update_info,",");
		 $update_info.= " WHERE ".$primary_id."=".$id_value;
		 
		 return $update_info;
		 
	}
}

if(!function_exists('getAddStatement')) {
		function getAddStatement($table,$array)
	{
	$keys = array_keys($array);
	$values = array_values($array);
		
	     $add_info = " INSERT INTO " . $table  . " (";
		 foreach($keys as $i=>$key) $add_info.= $key. ($i!=count($keys)-1 ? ", " : ""); 
		 $add_info.=") VALUES (";
		 foreach($values as $i=>$value) $add_info.= $value. ($i!=count($values)-1 ? ", " : ")"); 
		 return $add_info;
	
	}
	
}		

# This is a collection of functions useful for getting information out
# of the public (white pages) LDAP

##########################################################
#
# takes: a user id
#
# returns: an array of all publicly available info for that person
#
if(!function_exists('getInfoForPerson')) {
function getInfoForPerson($username = '')
{
  $debug = 0;

  if ($username == '')
  {
    if ($debug) { echo "\n"; }
    return 0;
  }

  $ldap_server    = 'ldap.williams.edu';
  $ldap_readDN    = 'cn=search,ou=people,o=williams';
  $ldap_readPass  = 'search4it'; 

  $link = ldap_connect($ldap_server);
  if ($link)
  {
    if ($debug) { echo "connection successful\n"; }
    $bind = ldap_bind($link,$ldap_readDN,$ldap_readPass);
    if ($bind)
    {
      if ($debug) { echo "bind successful\n"; }
      $search = ldap_search($link,'ou=people,o=williams',"(uid=$username)");
      if ($search)
      {
        if ($debug) { echo "search created\n"; }
        $results = ldap_get_entries($link,$search);
        if ($results)
        {
          if ($debug) { echo "got results\n"; }
          if ($debug) { print_r($results); }
          $results_array = array();
          for ($j=0; $j < $results[0]['count']; $j++)
          {
            $results_array[$results[0][$j]] = $results[0][$results[0][$j]][0];
          }
          ldap_free_result($search);
          ldap_close($link);
          return $results_array;
        }
      }
    }
    ldap_close($link);
  }

  if ($debug) { echo "fall through - returning 0\n"; }
  return 0;
}

}

//wrap and trim string to length
function wrap($str,$br="\n",$cut=true,$length=60) {
  return wordwrap(trim($str),$length,$br,$cut);
}

function notBlank(&$element) {
$element = trim($element);
    return (strlen($element) > 0 || !empty($element));
}
 

// formatPlainTextMessage
// takes the plain text, pre-formatted message (meant for display on email)
// formats it to HTML with heading, body, submitter etc.
function formatPlainTextMessage($message_body) {
		
         $break = "\n<br />";
	     $a     = preg_split('/\\n/', $message_body, -1, PREG_SPLIT_NO_EMPTY);
         $a     = array_values(array_filter($a, "notBlank"));

		$heading   = wrap(array_shift($a));
		
		if(substr($a[count($a)-1],0,4)== "from"){
		  $submitter = wrap(array_pop($a));
		 }
		 
		$short_body_html = "";
		$more = "MORE: http://www.williams.edu/messages/show";
		
		foreach($a as $i=>$text) {
		  if(substr($text,0,strlen($more))==$more) {
		       continue; //Don't show the text that reads "More: URL". We're putting that in a more aesthetic link underneath the summary.
	        }
	
	      // $text = str_replace("\n", " ",$text);
	       $text = str_replace("<a","\n<a",$text);
           $short_body_html.=$text.$break;
		 }
		 
		// return $short_body_html;
		 
	     return array($short_body_html,$submitter);	 
		 
	} //end function


// shorten
//Takes a string and cuts it off at the desired length with an ellipsis 
if(!function_exists("shorten")) {
            function shorten($string,$length,$end="...")  {
               return (strLen($string)>$length)?subStr($string,0,$length-strLen($end)).$end:$string; }
 }
 
 
 

// display audience
// takes a boolean variable for audience, and a string for text to display. Returns a formatted HTML tag.
function displayAudience($audience,$text,$tag="dt") {
return ($audience ? "<{$tag} class='audience-type'>$text</{$tag}>\n" : "");
} 

// makeLiveLink
// takes a text string and converts URLS and E-mails to live HTML <a> links
function makeLiveLink($txt) {

$live = str_replace(" www"," http://www",$txt);

//replace http:// or www. links
$live = preg_replace(
       '/(http\:\/\/\S+)/',
       '<a href="$1">$1</a>',
       $live);
	   
//replace email	   
$live= preg_replace("/([\w\.]+)(@)(([^\s\.]+)(\.)([^\s]*))/i","<a href=\"mailto:$1@$3\">$1@$4.$6</a>",$live); //e-mail replace


 return $live;
}



//formatDateHeading
//based on today's date, and the arguments provided in a search, return a formatted string of the current date(s) to display at the top of the page
function formatDateHeading() {
  global $begin_date,$end_date,$res_get_search_results,$default_dates,$todays_messages,$day_of_week;

  if($begin_date=="''" || $end_date=="''") { 
      $all_dates = array();
      while ($row = mysql_fetch_assoc($res_get_search_results))
	       array_push($all_dates,$row['publication_date']); 
       mysql_data_seek($res_get_search_results,0);
      if($begin_date=="''" ) $begin_date  = $all_dates[count($all_dates)-1];
      if($end_date  =="''" ) $end_date    = $all_dates[0];
    }

   //Strip quote marks from dates
   $begin_date = strtotime(str_replace("'","",$begin_date));
   $end_date   = strtotime(str_replace("'","",$end_date));

  //Display heading & include dates
   
   if(!showDates())
       return ($day_of_week!="Saturday" && $day_of_week!="Sunday" ? "Today: " : "") . date("l, F j Y",$begin_date);
 
  
    return date("l, F j Y",$begin_date) . ($begin_date!=$end_date ? " to ". date("l, F j Y",$end_date) : "");
}

//show date if a) it's not today and b) it's not the default dates
function showDates() {
  global $begin_date,$end_date,$todays_messages;

  if(!($default_dates || ($begin_date==$end_date && date("Y/m/d",$begin_date)==$todays_messages))) return true;
  return false;
}




//////////////////////////////////////////////////////////////////////////////
// class DailyMessage
//
//
//////////////////////////////////////////////////////////////////////////////

class DailyMessage
{
   // --------------------------
   // Declare class data members
   // --------------------------
   var $error;
   var $success;
   var $connection;
   var $debug;



   //=========================================================================
   //                    P U B L I C   M E T H O D S
   //=========================================================================


   //-------------------------------------------------------------------------
   // DailyMessage() - Default constructor
   //
   //   Initializes a new instance of an News object
   //
   function __construct() 
   {
            $this->error  = array();
			$this->success = array();
            $this->connection = mysql_connect($GLOBALS['dbHost'],$GLOBALS['dbUser'],$GLOBALS['dbPass']) or exit("Error connecting to db: ".mysql_error());
           mysql_select_db($GLOBALS['dbName'], $this->connection) or exit("Error connecting to db: ".mysql_error());
		 //  $this->debug(false); //turn debug off
   }
     
	function auth() {
	if (!$_SESSION['authenticated'])
    {  
       $host         = $_SERVER['HTTP_HOST'];
       $uri           = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
	   $login_page    = 'login/';
       $referrer      = str_replace('.php',"",array_pop(explode("/",  $_SERVER['PHP_SELF'])));
 
	    if($_POST['username'] || $_POST['password']) {
	      $message = 'Your username - password combination was not valid.';
	      header("Location: https://$host$uri/$login_page?".($referrer ? "ref=$referrer&" : "")."login_message=".urlencode($message)."&username=".$_POST['username']);   
	    }
	   
	     else {
	  	    header("Location: https://$host$uri/$login_page".($referrer ? "?ref=$referrer" : ""));    
	       } 
    }  
	
	return true;
  } 
  
  function authenticate() {
   return $this->auth();
    }
	 
     
  //  - Function error() ----------------------------------------------------------- 
  //    - Adds the error message to our error class variable and returns it 
  //    -----------------------------------------------------------------------------

   function error($msg)
   {
   $this->error[][time()]=$msg;
   if(session_id() != "")   $_SESSION["errors"] =  $this->error;
   return $this->error;
   } 

 
   // - Function success() ----------------------------------------------------------- 
   //   - Adds the success message to our success class variable and returns it 
   //   -----------------------------------------------------------------------------
   function success($msg)
   {
    $this->success[][time()]=$msg;
    if(session_id() != "") $_SESSION["success"] =  $this->success;
    return $this->success;
   } 
   
  
   
   
 // - Function query() ----------------------------------------------------------- 
 ///   - Querys the datavase
  //  ----------------------------------------------------------------------------
   function query($q)
   {
     return mysql_query($q, $this->connection);
   }
   
   function totalMessages($userid="") {
     if(!$userid) return 0;
   
      $q              = "SELECT COUNT(*) FROM message m WHERE m.submitter_userid='$userid'";
	  return $this->value($q);
 
   }
   
   
   function validateSubmitter($user_id, $message_id,$isdraft=1) {
	     //validate that user is the same as this draft or message... don't want to overwrite someone else's! 
		 $t       = $isdraft ?  'drafts' : 'message'; echo $t;
		 $p       = ($isdraft ? 'draft'  : 'message') . "_id";		 		 
	     $q       = "SELECT submitter_userid FROM $t WHERE $p=$message_id";
		 $sub     = $this->value($q);
		 if($sub != $user_id) return false;
		 return true;    
   }
   
   function validateOnHoldStatus($message_id) {
	     //validate that this message is on hold and can be edited 	 
	     $q       = "SELECT refused_flag,to_publish_flag,published_flag FROM message WHERE message_id=$message_id";
		 $res     = $this->query($q);
		 $row     = $this->row($res);
		 $onhold  = true;
		 
		 foreach($row as $field) {
            if($field==1) $onhold=false;
		 }
		 
		 return $onhold;
   }
     
   
   
   function totalDrafts($userid="") {
   //Get Total Messages
     if(!$userid) return 0;
      $q              = "SELECT COUNT(*) FROM drafts d WHERE d.submitter_userid='$userid'";
      return $this->value($q);
      }
	  

	  
   # Updated by Skye 1/5/08. Now instead of pasting this to the user, it simply echos an error message and sends the email to Skye/Chris or other web person.
   # takes: a string, email address
   # emails the tech support person.
function errorResponse($the_err_msg,$email_to="")
{
global $support_email;

$email_address = ($email_to ? $email_to : $support_email);
$email_name    = ($email_to ? $email_to : "Skye");
$message = 
"The system ran into a problem on ".date('r').": 

<pre>
$the_err_msg
</pre>
";

return false;

$mail    = new PHPMailer();
$body    = $message;
$mail->From     = "dailymessage_error@williams.edu";
$mail->Subject  = "Daily Message Notification";
$mail->MsgHTML($body);
$mail->AddAddress($email_address, $email_name);
$mail->Send();
}


function postBody() {
return "
  submitter_userid   = {$_POST['submitter_userid']}
  submitter_name     = {$_POST['submitter_name']}
  submitter_email    = {$_POST['submitter_email']}
  submitter_phone    = {$_POST['submitter_phone']}

  submitter_org      = {$_POST['submitter_org']}

  audience_student   = {$_POST['audience_student']}
  audience_faculty   = {$_POST['audience_faculty']}
  audience_staff     = {$_POST['audience_staff']}

  headline           = {$_POST['headline']}
  short_body         = {$_POST['formatted_message']}
  long_body          = {$_POST['longbody']}
  active_date        = {$_POST['active_date']}";

}
   
  
    // - Function getAssocArray() ------------------------------------------------ 
    //   - Returns an associative array based on a query string
    //-----------------------------------------------------------------------------
    function getAssocArray($query)
	{
	   if(!$query) return false;
	 $res = $this->query($query);
     if(!$res) return false;

	 $i = 0;
         while ($arr[$i++] = mysql_fetch_assoc($res)); 
           array_pop($arr);
	 return $arr;
	}
	
    // - Function getArray() ------------------------------------------------ 
    //   - Returns an regular array based on a query string
    //-----------------------------------------------------------------------------
	 function getArray($query,$return_single=false)
	 {
	 if(!$query) return false;
	 $res =  $this->query($query);
     if(!$res) return false;

	     $i = 0;
            while ($arr[$i++] = mysql_fetch_array($res)); //echo $arr[$i];
              array_pop($arr);
			  
	if($return_single) return $arr[0]; 
			  
    return $arr;
	}
	
	
    // - Function getRow() -------------------------------------------------------- 
    //   - Returns a row from a result set as an array
    //-----------------------------------------------------------------------------
	function row($res)
	{
	if(!$res) return false;
	 return mysql_fetch_array($res);
	}
	
	
	//value returns a single value
	//enter SQL query 
	function value($query) {
	  $result         = $this->query($query);
	    if(!$result) return false;
      $row            = $this->row($result);
	    if(!$row) return false;
	  return $row[0];

	}
	
	/*
	function getCategories()
	{
	  $q     = 'SELECT category_id, category_name FROM category ORDER BY category_ordering';
	  $array = $this->getArray($q);
	  return $array;
	}
	
	
	function getMessages()
	{
	  $q = $this->generateMessageSelectStart()."
      FROM 
       message m left outer join category c on c.category_id=m.category_id
      WHERE
       m.published_flag = 0
      ORDER BY
        m.refused_flag,
        ifnull(m.active_datetime,NOW()),
        (IF(m.to_publish_flag+m.to_foreshadow_flag+m.refused_flag < 1,1000,0) + (m.to_publish_flag*100))        desc,
        ifnull(c.category_ordering,0) asc,
        ifnull(c.category_name,'a') asc,
        m.ordering asc";
		
		echo $q;
		
		$array = $this->getArray($q);
		
		echo "<BR>".mysql_error($this->connection);
		
		return $array;
	}
	
	
	
#--------------------------------------------------------------------
# takes nothing

# returns the SQL for the beginning of a select statement to get all
# the data from a message row. The FROM, WHERE, and ORDER clauses are
# added in the called code.

function generateMessageSelectStart()
{
  $select_start =
"SELECT
m.message_id,
m.datetime_created,
m.submitter_userid ,
m.submitter_name ,
m.submitter_email ,
m.submitter_phone ,
m.submitter_org,
m.audience_students,
m.audience_faculty ,
m.audience_staff,
m.audience_other,
m.audience_extra1 ,
m.audience_extra2,
m.headline,
m.short_body,
m.long_body ,
DATE_FORMAT(m.active_datetime,'%a, %b %d') AS active_datetime,
m.short_summary,
DATE_FORMAT(m.summary_datetime,'%a, %b %d') AS summary_datetime,
m.submitter_comment,
m.refused_flag,
m.to_publish_flag,
m.published_flag,
m.to_foreshadow_flag,
m.foreshadowed_flag,
m.category_id,
m.ordering,
m.admin_comment";

  return $select_start;
}

	*/
		
}

	$dm = new DailyMessage();


?>