<?php $uri = rtrim(dirname($_SERVER['PHP_SELF']), '/\\') ;
require_once("/web".$uri."/includes/session.php");
include_once("/web".$_SERVER['DOCUMENT_ROOT']."/includes/_williams-lib.php");//include constants/server variables
require_once("/web".$uri."/includes/dm-class.php");

//Authorize user to be on this page
$dm->auth();

//Add some javascript library files
$js.=addScript(PROTOPACKED);
$js.=addScript($uri.'/includes/js/datetimepicker_mf.js');
$js.=addScript($uri.'/includes/js/message_functions.js');
$js.=addScript($uri.'/includes/js/message_form.js');
$js.=addScript(WILLIAMS_SCRIPTS."validation/validation.js");
$styleSheets.=addStyle(WILLIAMS_SCRIPTS."validation/style.css");

//Hide certain parts of the content-menu
$hideSearchForm    = true;
$hideSubmitMessage = true;

//Initialize page variables.
$id      = $_GET['id']    ? $_GET['id']   : 0; //Check if we have an ID which can be for a draft or a submitted message
$draft   = $_GET['draft'] ? 1 : 0; //Check if we are editing a 'draft'
$message = $id!=0 && !$draft ? 1 : 0; //Check if we are editing a message
$submit  = $message && $id ? 'Save' : 'Submit';

//If we have a $_GET[] request for an id (message OR draft)
if($id) {

  //Validate to make sure it is a number (to prevent SQL injection)
  //and check the user id against the $_SESSION[userid].
  if(!is_numeric($id)) {
	}
  else {
    $validate = $dm->validateSubmitter($_SESSION['userid'],quote_smart($id),$draft);
	if(!$validate) {$id=0;}
  }

  //Validate to make sure this message is 'on hold' and not accepted/rejected
  if($message) {
    $onhold = $dm->validateOnHoldStatus(quote_smart($id)); 
	if(!$onhold) {$id=0;  }
  }
  
  
  //If all is well and we have a valid  id
  //then we need to pull the data and display it on the form all ready for the user to edit
  if($id) 
	$d  = $dm->getArray("SELECT * FROM ".($message ? 'message WHERE message_id=' : 'drafts WHERE draft_id=').$id,true);
 
  //Otherwise spit out an error for the people trying to h@xx0r my code.
  else $message_error = "Invalid ".($message ? 'daily message' : 'draft')." id.";
}


//Get user information from LDAP Server.
$form_handler  = 'post_message_handler.php';
$userid        = $_SESSION['userid'];
$users_name    = 'unknown';
$users_email   = 'unknown';
$users_phone   = 'x????';
$default_org   = '';
$all_user_info = getInfoForPerson($userid);
if ($all_user_info){
  $users_name  = $all_user_info['cn'];
  $users_email = $all_user_info['mail'];
  $users_phone = preg_replace('/\(413\) 597\-/','x',$all_user_info['telephonenumber']);
  $default_org = $all_user_info['ou'];
}

include(WILLIAMS_FRAME); 


//Check that draft_id matches user id in database
//And is still a draft (e.g. hasn't been approved/rejected)
?>
 <style>
  #status_update { color:#746880; font-size:0.9em; width:730px; clear:both; left:0; right:0;position:fixed; margin:0px auto; bottom:0; padding:4px 8px; border:1px solid #cab5df;  border-bottom:none;background-color:#e2daea; z-index:99999999;}
  .attn { color: #FF0000; font-weight:bold;}
  .urg_attn {font-size:1.2em;}
  
  .submit-form label {font-family:"Trebuchet MS",Trebuchet, helvetica, arial; color:#663399; font-size:1.2em; font-weight:bold; padding-bottom:4px;margin-bottom:5px; clear:both;}
  .submit-form label.plain {font-family:Verdana, Arial, Helvetica, sans-serif; color:#333;; font-size:1.0em; font-weight:normal; margin-bottom:0px; display:inline;}
  .submit-form input {padding:5px;}
  .submit-form textarea {width:98%; padding:5px;}
 
  .important {margin:15px 0 15px 0; padding:6px; border:1px dashed #CC0000;}
  .submit-form .preview_block { padding:8px;border:1px dashed #ccc; white-space:pre; font-family:"Courier New", Courier, mono; font-size:14px; color:black; }
 
   #headline_ID, #submitter_org_ID {width:98%;;}
 </style>
  
<form id='post_message_form' action="<?php echo "https://www.williams.edu{$root_loc}/{$form_handler}"; ?>" onsubmit="return false;" method="POST" style="">
<input type="hidden" name="submitter_userid" value="<?=$userid?>" id="submitter_userid_ID">
<input type="hidden" name="submitter_name" value="<?=$users_name?>" id="submitter_name_ID">
<input type="hidden" name="submitter_email" value="<?=$users_email?>" id="submitter_email_ID">
<input type="hidden" name="submitter_phone" value="<?=$users_phone?>" id="submitter_phone_ID">
<input type="hidden" name="formatted_message" value="" id="formatted_message_ID">
<input type="hidden" name="message_id_orig" value="<?=$id;?>" id="message_ID">

  
<h2>Submit A Daily Message</h2>
<? echo $id ? "<h3>Editing a ".($message ? 'message':'draft') . " created on ".date("M j, Y g:i A",strtotime($d['datetime_created']))."</h3>" : "";?>
<? echo $message_error ? "<p class='errormsg'>$message_error</p>" : "";  ?>

<div id='status_update'></div>

<div class="important">
<p><span class="attn">DON'T FORGET</span><br />
to click the "<b><?=strtoupper($submit);?> MESSAGE</b>" button at the bottom of this page!</p>
 
<p><span class="attn">DEADLINE</span></br /><strong><br />
  3 p.m. Monday through Friday</strong><br />
 <em>Messages for Monday must be submitted by 3 p.m. on Friday.</em></p>
 </div>
 
<div class="submit-form">
<div>
 <label>Submitted by:</label>
 <p style="font-size:1.2em;"><strong><?=$users_name?> (<?=$userid?>)</strong></p>
</div>

<div>
  <label for='submitter_org_ID'>Department/Organization:</label>
 <p><input class="required" type="text" name="submitter_org" value="<? echo $d['submitter_org'] ? $d['submitter_org'] : $default_org; ?>" size="48" maxlength="48" id="submitter_org_ID" /></p>
</div>

<div>
  <label for=''>Message for:</label>
 <p><input <? echo $d['audience_students']==1 ? 'checked' : ""; ?> type="checkbox" name="audience_student" id="audience_student_ID"><label class="plain" for='audience_student_ID' title="All frosh, sophomores, juniors, senior, and grad students">Students</label> 
<input <? echo $d['audience_faculty']==1 ? 'checked' : ""; ?> style="margin-left:20px;" type="checkbox" name="audience_faculty" id="audience_faculty_ID"><label class="plain" for='audience_faculty_ID' title="All faculty members">Faculty</label> 
<input <? echo $d['audience_staff']==1 ? 'checked' : ""; ?> style="margin-left:20px;"  type="checkbox" name="audience_staff" id="audience_staff_ID"><label class="plain" for='audience_staff_ID' title="All staff">Staff</label></p>
</div>

<div>
  <label for='IDactive_dateButton'>Date to publish:</label>
 <p>   <img style="vertical-align:middle" name="active_dateButton"
       id="IDactive_dateButton"
       src="<?=$root_loc?>/img/popup_calendar_button.gif"
       title="Click to choose the 'to date'"
       alt="Date picker popup calendar"
       onclick="displayDatePicker('active_date', this, 'ymd', '/');">
   <input class="bigdatefield" type="text" 
          name="active_date" id="active_date_ID" value="<? echo $d['active_datetime'] ? date("Y/m/d",strtotime($d['active_datetime'])) : "----/--/--"; ?>" size="10" readonly="readonly"><br />

<i>Daily Messages are e-mailed on weekdays only (no Saturday/Sunday delivery).</i></p>
</div>


<div>
  <label for='headline_ID'>Message headline:</label>
 <p><input type="text" class="required"  name="headline" value="<?=$d['headline'];?>" maxlength="65" id="headline_ID" ></p>
</div>


<div>
  <label for='shortbody_ID'>Message summary:</label>
 <p><em>If this box turns pink, your summary is too long.</em><br /><textarea class="required"  name="shortbody" id="shortbody_ID" rows="7" style='overflow:scroll' ><? echo ($d['short_body_html'] ? $d['short_body_html'] : $d['short_body']);?></textarea>
<input name='shortbodyhtml' type="hidden" id="shortbodyhtml_ID" />
</p>
</div>


<div>
  <label for='preview_text_ID'>Message preview:</label>
   <p class='preview_block' id="preview_text_ID" style="overflow:scroll; height:100px;">
       <? echo ($id==0 ? 'Message Preview appears here.<br />' : $d['short_body']); ?>
 </p>
</div>


<p><span class="attn">Making a Link</span><br />To make an active link in <strong>message summary</strong> or <strong>long message</strong>, simply include the entire URL: ie, <strong>http://www.williams.edu</strong>. <em>Do not use HTML.</em></td>
</p>

<div>
  <label for='shortbody_ID'>Long Message: (optional)</label>
 <p><em>Message summary will include a link to this long message. (You can compose and spell check long messages in a text program;<strong> save as 'text-only'</strong>; then copy and paste here.)</em><br /><textarea name="longbody" id="longbody_ID" rows="20" ><?=$d['long_body'];?></textarea><br /><i>(This field is limited to about one page of text.)</i>
</p>
</div>
</div>

<p class="submit" style="width:198px;height:45px;"><input id='submit_button' alt="Submit Message" src="/messages/img/<?=strtolower($submit);?>_button.gif" type="image"  /></p>
<!--&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" name="cancel_message" value="CANCEL">-->
<p><em>You will be forwarded to a page that says: "Your message has been <? echo (!$message ? 'submitted' : 'saved');?>."</em></p>

</form>

<script>

//Validate form
function formCallback(result, form) {
							window.status = "valiation callback for form '" + form.id + "': result = " + result;
}
						
var valid = new Validation('post_message_form', {immediate : true, onFormValidate : formCallback});


//Make a collection of input elements in the form
var tracks = new Array('submitter_org_ID','headline_ID','shortbody_ID','longbody_ID');

//For each element, track the preview message when the element is either a) blurred or b) a keystroke is entered
tracks.each(function(tracker) {
$(tracker).observe('keyup',function(event){trackPreviewMessage();});
$(tracker).observe('blur',function(event){trackPreviewMessage();});
 
}); 

//Hide our status update debug message element  
//$('status_update').hide();

//Set some page variables from PHP
var id      = '<?=$id;?>';
var message = '<?=$message;?>';
var draft   = '<?=$draft;?>';
var counter     = 0;
var saveCounter = 0;

//Set up a periodic executer to save every 10 seconds
new PeriodicalExecuter(function(pe) {
trackPreviewMessage(); //added 5/19/08 as summary fields were occasionally rendered blank.
saveMessage(false);
saveCounter++;
}, 10); 


//Save Message to messages db.
 Event.observe($('submit_button'), 'click', function(event){
		   trackPreviewMessage(); 
		   var v = validateForm();
		   if(v) { saveMessage(true);  }
});



function saveMessage(dosubmit) {

var status      = (message=='1' ? "message=true&" : "");
var formData    = $('post_message_form').serialize();
var action      = (id!='0' ? 'update' : 'insert');

if(draft=='1') {
    if(dosubmit) action='insert';
}


var currentTime = '<?=date("M j, Y"); ?>';
var submitting  = (dosubmit ? "submit=true&" : "" ); 

//Get Current Time
new Ajax.Request('includes/current_time.php', {method: 'post',onSuccess: function(time) { currentTime = time.responseText; }});

new Ajax.Request('message_handler.php', {
  method: 'post',
  postBody: "action=" + action + "&id=" + id + "&" + status + submitting + formData,
  onSuccess: function(transport) {	
  
    if(dosubmit) {
       <? $_GET[]=""; $_POST[]="";?> window.location='<?=$form_handler;?>?msg='+transport.responseText;
    }
	
 
	  if(transport.responseText!='blank')  {
	    $('status_update').show();
        $('status_update').innerHTML = (message=='1' ? "Message" :"Draft")+" autosaved on "+currentTime;
	   $('status_update').innerHTML = "("+counter+") "+(message=='1' ? "Message" :"Draft")+" autosaved on "+currentTime+ " "+transport.responseText;  
	    counter++; //for debuggin'
	    id = transport.responseText;
		}

	},
	onFailure: function(transport) {
	     $('status_update').innerHTML="Failed to autosave on "+currentTime;// + " "+transport.responseText;
	}
  });
} 



 function buildPreviewMessage()
  {
    var debugMe = 0;

    var messageHeadline    = cleanTextFromMSWord($("headline_ID").getValue());
    var messageShortbody   = cleanTextFromMSWord($("shortbody_ID").getValue());
    var messageLongbody    = cleanTextFromMSWord($("longbody_ID").getValue());
    var messageSubmitter   = "<?=$users_name?>";
    var messageOrg         = $("submitter_org_ID").getValue();
    var formattedShortbody = "";

    messageShortbody = messageShortbody.replace(/\<[^\>]*?\>/g,' ');
    messageHeadline  = messageHeadline.replace(/\s+/g,' ');
    messageShortbody = messageShortbody.replace(/\s+/g,' ');
    messageShortbody = messageShortbody.replace(/\</g,'&lt;');
    messageShortbody = messageShortbody.replace(/\>/g,'&gt;');
    messageShortbody = messageShortbody.replace(/^\s+|\s+$/,'');
	
	$("shortbodyhtml_ID").value = messageShortbody;
	

    var formattedLines    = new Array();
    var numFormattedLines = 0;
    var lineSize          = 65;
    var maxLines          = 5;
    var indenting         = '     ';
    var lastLine          = "from "+ messageSubmitter +", "+messageOrg;
    var padding           = '';
   
   for (var spaceCounter=0; spaceCounter<lineSize; spaceCounter++)
    {
      padding = padding + ' ';
    }
    //lastLine = "\n"+padding.slice(0,lineSize-lastLine.length-1)+lastLine;
    lastLine = "\n"+indenting+indenting+lastLine;

    if ((debugMe > 0) && (messageShortbody.length > 58))
    {
      alert("messageShortbody.length is "+messageShortbody.length+"\nlineSize is "+lineSize);
    }

    if (messageShortbody.length <= lineSize)
    {
      formattedLines[0] = messageShortbody;
    } else // message > line size
    {
      var lastBreakPos = 0;
      var breakPos = messageShortbody.lastIndexOf(' ',lastBreakPos+lineSize);
      if (debugMe > 0)
      {
        alert("breakPos is "+breakPos+"\n");
      }
      var counter=0;
      while ((breakPos > -1) && (lastBreakPos < breakPos))
      {
        counter++;
        if ((counter < 25) && (debugMe > 0))
        {
          alert("breakPos is "+breakPos+"\n");
        }
        formattedLines[numFormattedLines] = messageShortbody.slice(lastBreakPos,breakPos);
        numFormattedLines++;
        lastBreakPos = breakPos+1;
        breakPos = messageShortbody.lastIndexOf(' ',lastBreakPos+lineSize);
      }

      var lastFragment = messageShortbody.slice(lastBreakPos,messageShortbody.length);

      if ((lastFragment.length + formattedLines[numFormattedLines-1].length + 1) <= lineSize)
      {
        formattedLines[numFormattedLines-1] += ' '+lastFragment;
      } else
      {
        formattedLines[numFormattedLines] = lastFragment;
      }

    } // end  message > line size

    if (formattedLines.length <= maxLines)
    {
      formattedShortbody = indenting+formattedLines.join("\n"+indenting);
      document.getElementById('shortbody_ID').style.background = 'white';
    }
    else
    {
      var lastWordBreak = formattedLines[maxLines].lastIndexOf(' ');
      document.getElementById('shortbody_ID').style.background = '#eecccc';
      formattedShortbody = indenting + formattedLines.slice(0,maxLines).join("\n"+indenting);
    }
    var linkOut = "";
    var longMessageBody = document.getElementById("longbody_ID").value;
    longMessageBody = longMessageBody.replace(/^\s+|\s+$/g,"");
    if (longMessageBody.length > 0)
    {
      <?php
      $detail_uri = preg_replace('/\/user.*$/','/public/show.php?id=123456',$uri);
      $detail_uri = "$uri/show.php?id=123456";
      echo "linkOut += \"\\n     MORE: http://$host$detail_uri\";";
      //echo "alert(\"uri is $uri\");";
      ?>

    }
    //bufferedMessage = "<pre>" + messageHeadline + "\n" + formattedShortbody + "\n" + lastLine + "\n" + linkOut + "</pre>";
    var formattedText = '' + messageHeadline + "\n" + formattedShortbody + linkOut + lastLine;
    formattedText = formattedText.replace(/^\s+|\s+$/g,'');
    bufferedMessage = formattedText;
    $("formatted_message_ID").value = formattedText;
  }

</script>


<?php
include(WILLIAMS_FRAME); ?>